#!/usr/bin/env bash
# Quick translation runner script

cd "$(dirname "$0")" || exit 1

# Check if artisan exists
if [ ! -f "./artisan" ]; then
    echo "Error: artisan file not found in current directory"
    exit 1
fi

echo "🌐 Starting automatic translation process..."
echo ""
echo "This will translate your language files using the free MyMemory API"
echo ""

# Try different ways to find PHP
if command -v php &> /dev/null; then
    PHP_CMD="php"
elif command -v php8.3 &> /dev/null; then
    PHP_CMD="php8.3"
elif command -v php8.2 &> /dev/null; then
    PHP_CMD="php8.2"
else
    echo "❌ PHP not found in PATH. Please ensure PHP CLI is installed."
    exit 1
fi

echo "✓ Using PHP: $PHP_CMD"
echo ""

# Run the translation command
$PHP_CMD artisan translate:strings --targets=ar,es,fr,hi

echo ""
echo "✅ Translation complete!"
echo ""
echo "Your language files have been updated in: resources/lang/"
echo ""
