<!DOCTYPE html>
<html lang="<?php echo e(str_replace('_', '-', $locale)); ?>" dir="<?php echo e($isRtl ? 'rtl' : 'ltr'); ?>">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <meta name="dark-mode-toggle-url" content="<?php echo e(route('dark-mode.toggle')); ?>">
    
    <title>
        <?php if (! empty(trim($__env->yieldContent('title')))): ?>
            <?php echo $__env->yieldContent('title'); ?> | <?php echo e($appName); ?>

        <?php else: ?>
            <?php echo e($appName); ?>

        <?php endif; ?>
    </title>
    
    <meta name="description" content="<?php echo $__env->yieldContent('meta_description', __('Download the latest Android apps and games for free. Safe, fast, and secure downloads.')); ?>">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Space+Grotesk:wght@400;500;600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Styles & Scripts -->
    <?php echo app('Illuminate\Foundation\Vite')(['resources/css/app.css', 'resources/js/app.js']); ?>
    <?php echo $__env->yieldPushContent('head'); ?>
<link rel="stylesheet" href="/custom-style.css">
</head>
<body class="<?php echo \Illuminate\Support\Arr::toCssClasses(['antialiased', 'dark' => $isDarkMode]); ?>">
    <div class="site-shell">
        
        <header class="site-header">
            <div class="site-header-inner">
                
                <a href="<?php echo e(route('home')); ?>" class="site-logo">
                    <?php echo $__env->make('components.digital-logo', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    <div>
                        <p class="logo-text text-xl"><?php echo e($appName); ?></p>
                        <p class="logo-sub"><?php echo e(__('apks.center')); ?></p>
                    </div>
                </a>

                
                <nav class="nav-links hidden lg:flex" aria-label="<?php echo e(__('Primary navigation')); ?>">
                    <?php $__currentLoopData = $navLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <a 
                            href="<?php echo e($link['route']); ?>"
                            class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link', 'nav-link-active' => $link['active']]); ?>"
                            <?php if($link['active']): ?> aria-current="page" <?php endif; ?>
                        >
                            <?php echo e($link['label']); ?>

                        </a>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </nav>

                
                <div class="site-actions hidden lg:flex">
                    
                    <form action="<?php echo e(route('apps.search')); ?>" method="GET" class="site-search relative">
                        <input
                            type="text"
                            name="q"
                            value="<?php echo e(request('q')); ?>"
                            placeholder="<?php echo e(__('Search apps...')); ?>"
                            aria-label="<?php echo e(__('Search apps')); ?>"
                        >
                        <span class="pointer-events-none">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.2-5.2m0 0a7.5 7.5 0 1 0-10.6-10.6 7.5 7.5 0 0 0 10.6 10.6z"/>
                            </svg>
                        </span>
                    </form>

                    
                    <div class="language-switcher inline-flex items-center gap-2">
                        <span class="text-muted uppercase tracking-[0.3em] text-xs"><?php echo e(strtoupper($locale)); ?></span>
                        <?php echo $__env->make('components.language-switcher', [
                            'wrapperClass' => 'inline-flex items-center',
                            'selectClass' => 'language-select',
                        ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                    </div>

                    
                    <button id="darkModeToggle" type="button" class="pill-button" aria-label="<?php echo e(__('Toggle dark mode')); ?>">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79Z"/>
                        </svg>
                        <span class="text-xs font-semibold"><?php echo e($isDarkMode ? __('Light') : __('Dark')); ?></span>
                    </button>
                </div>

                
                <button id="mobileMenuToggle" type="button" class="pill-button lg:hidden" aria-label="<?php echo e(__('Toggle menu')); ?>">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                    <span class="text-xs font-semibold"><?php echo e(__('Menu')); ?></span>
                </button>
            </div>
        </header>

        
        <div id="mobileMenu" class="mobile-menu hidden lg:hidden p-4">
            
            <nav class="flex flex-col gap-2 border-b border-border pb-4 mb-4" aria-label="<?php echo e(__('Mobile navigation')); ?>">
                <?php $__currentLoopData = $navLinks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $link): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <a 
                        href="<?php echo e($link['route']); ?>"
                        class="<?php echo \Illuminate\Support\Arr::toCssClasses(['nav-link w-full text-left justify-between flex', 'nav-link-active' => $link['active']]); ?>"
                        <?php if($link['active']): ?> aria-current="page" <?php endif; ?>
                    >
                        <span><?php echo e($link['label']); ?></span>
                        <?php if($link['active']): ?>
                            <span class="text-xs text-accent font-medium"><?php echo e(__('Active')); ?></span>
                        <?php endif; ?>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </nav>

            
            <form action="<?php echo e(route('apps.search')); ?>" method="GET" class="mb-4">
                <label class="sr-only"><?php echo e(__('Search apps')); ?></label>
                <div class="relative">
                    <input 
                        type="text"
                        name="q"
                        value="<?php echo e(request('q')); ?>"
                        class="input-field pl-5 pr-10"
                        placeholder="<?php echo e(__('Search apps...')); ?>"
                    >
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-muted">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.2-5.2m0 0a7.5 7.5 0 1 0-10.6-10.6 7.5 7.5 0 0 0 10.6 10.6z"/>
                        </svg>
                    </span>
                </div>
            </form>

            
            <div class="mt-4 flex items-center gap-3">
                <div class="flex-1">
                    <?php echo $__env->make('components.language-switcher', [
                        'wrapperClass' => 'inline-flex items-center gap-2',
                        'selectClass' => 'language-select',
                    ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                </div>
                <button id="mobileDarkToggle" type="button" class="pill-button flex-shrink-0 min-w-[100px] justify-center">
                    <?php echo e($isDarkMode ? __('Light') : __('Dark')); ?>

                </button>
            </div>
        </div>

        
        <main class="site-main">
            <div class="page-wrapper">
                <?php echo $__env->yieldContent('content'); ?>
            </div>
        </main>

        
        <footer class="footer-shell">
            <div class="footer-inner">
                
                <div class="space-y-3">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted"><?php echo e(__('About')); ?></p>
                    <h3 class="footer-heading"><?php echo e(__('Android downloads reimagined')); ?></h3>
                    <p class="footer-muted text-sm">
                        <?php echo e(__('Fresh builds, curated selections, and multilingual experiences in a single lightning-fast catalog.')); ?>

                    </p>
                </div>

                
                <div class="footer-links">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted"><?php echo e(__('Navigation')); ?></p>
                    <div class="mt-2 space-y-2">
                        <a href="<?php echo e(route('apps.latest')); ?>"><?php echo e(__('Latest Apps')); ?></a>
                        <a href="<?php echo e(route('apps.popular')); ?>"><?php echo e(__('Top Downloads')); ?></a>
                        <a href="<?php echo e(route('apps.categories')); ?>"><?php echo e(__('Browse Categories')); ?></a>
                        <a href="<?php echo e(route('contact')); ?>"><?php echo e(__('Contact')); ?></a>
                    </div>
                </div>

                
                <div class="footer-links">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted"><?php echo e(__('Policies')); ?></p>
                    <div class="mt-2 space-y-2">
                        <a href="<?php echo e(route('about')); ?>"><?php echo e(__('About Us')); ?></a>
                        <a href="<?php echo e(route('terms')); ?>"><?php echo e(__('Terms of Service')); ?></a>
                        <a href="<?php echo e(route('privacy')); ?>"><?php echo e(__('Privacy Policy')); ?></a>
                    </div>
                </div>

                
                <div class="space-y-3">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted"><?php echo e(__('Support')); ?></p>
                    <p class="footer-muted text-sm">
                        <?php echo e(__('Need help importing or distributing an APK? Drop us a line anytime at support@apks.center')); ?>

                    </p>
                    <a href="mailto:support@apks.center" class="footer-cta mt-4">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.012 1.874l-7.5 4.688a2.25 2.25 0 0 1-2.25 0l-7.5-4.688A2.25 2.25 0 0 1 2.25 6.993V6.75" />
                        </svg>
                        <span class="text-xs font-semibold"><?php echo e(__('Email support')); ?></span>
                    </a>
                </div>
            </div>

            
            <div class="footer-bottom">
                <p class="text-xs">
                    <?php echo e(__('© :year :app_name. All rights reserved.', ['year' => now()->year, 'app_name' => $appName])); ?>

                </p>
                <p class="text-xs">
                    <?php echo e(__('Curated in multiple locales for multilingual users worldwide.')); ?>

                </p>
            </div>
        </footer>
    </div>

    <?php echo $__env->yieldPushContent('scripts'); ?>
</body>
</html><?php /**PATH /home/apksykyz/public_html/resources/views/layouts/app.blade.php ENDPATH**/ ?>