<?php $__env->startSection('title', $app->getTranslatedName()); ?>

<?php $__env->startPush('head'); ?>
    <script defer src="https://cdn.jsdelivr.net/npm/alpinejs@3.x.x/dist/cdn.min.js"></script>
    <?php if(!empty($schemaData)): ?>
        <script type="application/ld+json"><?php echo json_encode($schemaData, JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE); ?></script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('styles'); ?>
    <style>
        [x-cloak] { display: none !important; }
    </style>
<?php $__env->stopPush(); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800" x-data="appShowData()">

    <!-- Breadcrumb -->
    <div class="bg-white dark:bg-gray-800 shadow-sm">
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-4">
            <nav class="flex" aria-label="Breadcrumb">
                <ol class="flex items-center space-x-2 rtl:space-x-reverse">
                    <li>
                        <a href="<?php echo e(route('home')); ?>" class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                            <?php echo e(__('Home')); ?>

                        </a>
                    </li>
                    <li>
                        <svg class="flex-shrink-0 h-5 w-5 text-gray-400 rtl:rotate-180" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    </li>
                    <li>
                        <a href="<?php echo e(route('apps.category', $app->category->slug)); ?>" class="text-gray-500 hover:text-gray-700 dark:text-gray-400 dark:hover:text-gray-300">
                            <?php echo e($app->category->getTranslatedName()); ?>

                        </a>
                    </li>
                    <li>
                        <svg class="flex-shrink-0 h-5 w-5 text-gray-400 rtl:rotate-180" fill="currentColor" viewBox="0 0 20 20">
                            <path fill-rule="evenodd" d="M7.293 14.707a1 1 0 010-1.414L10.586 10 7.293 6.707a1 1 0 011.414-1.414l4 4a1 1 0 010 1.414l-4 4a1 1 0 01-1.414 0z" clip-rule="evenodd"/>
                        </svg>
                    </li>
                    <li>
                        <span class="text-gray-900 dark:text-white font-medium"><?php echo e($app->getTranslatedName()); ?></span>
                    </li>
                </ol>
            </nav>
        </div>
    </div>

    <!-- App Details Section -->
    <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 py-8">
        <div class="grid grid-cols-1 lg:grid-cols-3 gap-8">
            <!-- Main Content -->
            <div class="lg:col-span-2 space-y-6">
                <!-- App Header -->
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                    <div class="flex flex-col sm:flex-row gap-6">
                        <!-- App Icon -->
                        <div class="flex-shrink-0">
                            <img src="<?php echo e($app->icon_url); ?>"
                                alt="<?php echo e($app->getTranslatedName()); ?> icon"
                                class="w-24 h-24 sm:w-32 sm:h-32 rounded-2xl shadow-lg object-cover">
                        </div>

                        <!-- App Info -->
                        <div class="flex-1 space-y-3">
                            <div>
                                <h1 class="text-2xl sm:text-3xl font-bold text-gray-900 dark:text-white mb-2">
                                    <?php echo e($app->getTranslatedName()); ?>

                                </h1>
                                <p class="text-gray-600 dark:text-gray-400">
                                    <?php echo e($app->developer); ?>

                                </p>
                            </div>

                            <!-- App Stats - Enhanced Rating Visualization -->
                            <div class="flex flex-wrap items-center gap-x-6 gap-y-2 text-sm">
                                <div class="flex items-center space-x-2 rtl:space-x-reverse">
                                    <!-- Star Rating Component -->
                                    <div class="flex text-yellow-400">
                                        <?php for($i = 1; $i <= 5; $i++): ?>
                                            <?php if($app->rating >= $i): ?>
                                                <!-- Full Star -->
                                                <svg class="w-5 h-5" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                            <?php elseif($app->rating > $i - 1): ?>
                                                <!-- Half Star -->
                                                <svg class="w-5 h-5" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 20 20" fill="currentColor">
                                                    <defs><linearGradient id="half-fill-<?php echo e($app->id); ?>" x1="0%" y1="0%" x2="100%" y2="0%"><stop offset="<?php echo e(($app->rating - ($i - 1)) * 100); ?>%" stop-color="currentColor"/><stop offset="<?php echo e(($app->rating - ($i - 1)) * 100); ?>%" stop-color="rgb(209 213 219)"/></linearGradient></defs>
                                                    <path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z" fill="url(#half-fill-<?php echo e($app->id); ?>)" stroke="rgb(209 213 219)" stroke-width="0.5"/>
                                                </svg>
                                            <?php else: ?>
                                                <!-- Empty Star -->
                                                <svg class="w-5 h-5 text-gray-300 dark:text-gray-600" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                            <?php endif; ?>
                                        <?php endfor; ?>
                                    </div>
                                    <span class="font-medium text-gray-900 dark:text-white"><?php echo e(number_format($app->rating, 1)); ?></span>
                                </div>

                                <div class="flex items-center space-x-1 rtl:space-x-reverse text-gray-600 dark:text-gray-400">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                                    </svg>
                                    <span><?php echo e($app->formatted_downloads); ?></span>
                                </div>
                                <div class="flex items-center space-x-1 rtl:space-x-reverse text-gray-600 dark:text-gray-400">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h.01M7 3h5c.512 0 1.024.195 1.414.586l7 7a2 2 0 010 2.828l-7 7a2 2 0 01-2.828 0l-7-7A1.994 1.994 0 013 12V7a4 4 0 014-4z"/>
                                    </svg>
                                    <span><?php echo e($app->latest_version); ?></span>
                                </div>
                                <div class="flex items-center space-x-1 rtl:space-x-reverse text-gray-600 dark:text-gray-400">
                                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16l4.586-4.586a2 2 0 012.828 0L16 16m-2-2l1.586-1.586a2 2 0 012.828 0L20 14m-6-6h.01M6 20h12a2 2 0 002-2V6a2 2 0 00-2-2H6a2 2 0 00-2 2v12a2 2 0 002 2z"/>
                                    </svg>
                                    <span><?php echo e($app->formatted_size); ?></span>
                                </div>
                            </div>

                            <!-- Category Badge -->
                            <div class="flex flex-wrap items-center gap-2">
                                <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-blue-100 text-blue-800 dark:bg-blue-900 dark:text-blue-200">
                                    <?php echo e($app->category->getTranslatedName()); ?>

                                </span>
                                <?php if($app->featured): ?>
                                    <span class="inline-flex items-center px-3 py-1 rounded-full text-xs font-medium bg-yellow-100 text-yellow-800 dark:bg-yellow-900 dark:text-yellow-200">
                                        <?php echo e(__('Featured')); ?>

                                    </span>
                                <?php endif; ?>
                            </div>
                        </div>
                    </div>

                    <!-- Download Button -->
                    <div class="mt-6">
                        <a href="<?php echo e(route('download.show', $app->slug)); ?>"
                           class="inline-flex items-center justify-center w-full sm:w-auto px-8 py-3 bg-gradient-to-r from-blue-600 to-purple-600 text-white font-semibold rounded-xl shadow-lg hover:shadow-xl transform hover:scale-105 transition-all duration-200 focus:outline-none focus:ring-4 focus:ring-blue-500/50">
                            <svg class="w-5 h-5 mr-2 rtl:ml-2 rtl:mr-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                            </svg>
                            <?php echo e(__('Download')); ?>

                        </a>
                    </div>
                </div>

                <!-- Description -->
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-4">
                        <?php echo e(__('About this app')); ?>

                    </h2>
                    <div class="prose prose-gray dark:prose-invert max-w-none">
                        <p class="text-gray-700 dark:text-gray-300 leading-relaxed">
                            <?php echo e($app->getTranslatedDescription()); ?>

                        </p>
                    </div>
                </div>

                <!-- Screenshots - Integrated with Alpine Modal -->
                <?php if(is_array($app->screenshots) && count($app->screenshots) > 0): ?>
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-4">
                            <?php echo e(__('Screenshots')); ?>

                        </h2>
                        <div class="grid grid-cols-2 sm:grid-cols-3 md:grid-cols-4 gap-4">
                            <?php $__currentLoopData = $app->screenshots; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $screenshot): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="relative group cursor-pointer"
                                     @click="openModal('<?php echo e($screenshot); ?>', <?php echo e($index); ?>)">
                                    <img src="<?php echo e($screenshot); ?>"
                                        alt="<?php echo e($app->getTranslatedName()); ?> screenshot <?php echo e($index + 1); ?>"
                                        class="w-full h-32 md:h-40 object-cover rounded-lg shadow-md group-hover:shadow-xl transition-shadow duration-200">
                                    <div class="absolute inset-0 bg-black bg-opacity-0 group-hover:bg-opacity-10 transition-opacity duration-200 rounded-lg"></div>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Additional Information -->
                <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                    <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-4">
                        <?php echo e(__('Additional Information')); ?>

                    </h2>
                    <div class="grid grid-cols-1 sm:grid-cols-2 gap-x-8 gap-y-4">
                        <?php
                            $infoFields = [
                                ['label' => __('Package Name'), 'value' => $app->package_name],
                                ['label' => __('Latest Version'), 'value' => $app->latest_version],
                                ['label' => __('Developer'), 'value' => $app->developer],
                                ['label' => __('OS Requirement'), 'value' => $app->os_requirement ?: 'Android 5.0+'],
                                ['label' => __('Size'), 'value' => $app->formatted_size],
                                ['label' => __('Downloads'), 'value' => $app->formatted_downloads],
                            ];
                        ?>

                        <?php $__currentLoopData = $infoFields; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="flex flex-col py-2 border-b border-gray-200 dark:border-gray-700">
                                <span class="text-sm text-gray-600 dark:text-gray-400"><?php echo e($field['label']); ?></span>
                                <span class="text-lg text-gray-900 dark:text-white font-medium"><?php echo e($field['value']); ?></span>
                            </div>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>

                <!-- Versions History -->
                <?php if($versions->count() > 0): ?>
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                        <h2 class="text-xl font-bold text-gray-900 dark:text-white mb-4">
                            <?php echo e(__('Version History')); ?>

                        </h2>
                        <div class="space-y-4">
                            <?php $__currentLoopData = $versions; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $version): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="border border-gray-200 dark:border-gray-700 rounded-xl p-4 hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <div class="flex justify-between items-start mb-2">
                                        <div>
                                            <h3 class="font-semibold text-gray-900 dark:text-white">
                                                <?php echo e($version->version_name); ?>

                                                <?php if($version->is_beta): ?>
                                                    <span class="ml-2 inline-flex items-center px-2 py-1 rounded-full text-xs font-medium bg-orange-100 text-orange-800 dark:bg-orange-900 dark:text-orange-200">
                                                        <?php echo e(__('Beta')); ?>

                                                    </span>
                                                <?php endif; ?>
                                            </h3>
                                            <p class="text-sm text-gray-600 dark:text-gray-400">
                                                <?php echo e(__('Released on')); ?>: <?php echo e($version->release_date ? $version->release_date->format('M d, Y') : 'Unknown'); ?>

                                            </p>
                                        </div>
                                        <div class="text-right flex-shrink-0">
                                            <p class="text-sm font-medium text-gray-900 dark:text-white">
                                                <?php echo e($version->formatted_size); ?>

                                            </p>
                                            <p class="text-xs text-gray-600 dark:text-gray-400">
                                                v<?php echo e($version->version_code); ?>

                                            </p>
                                        </div>
                                    </div>
                                    <?php if($version->changelog): ?>
                                        <div class="text-sm text-gray-700 dark:text-gray-300">
                                            <?php echo e(Str::limit($version->changelog, 200)); ?>

                                        </div>
                                    <?php endif; ?>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                        <!-- Pagination -->
                        <?php if($versions->hasPages()): ?>
                            <div class="mt-6">
                                <?php echo e($versions->links()); ?>

                            </div>
                        <?php endif; ?>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Sidebar -->
            <div class="space-y-6">
                <!-- Quick Download -->
                <div class="bg-gradient-to-br from-blue-600 to-purple-600 rounded-2xl shadow-xl p-6 text-white">
                    <h3 class="text-xl font-bold mb-4 border-b border-blue-400/50 pb-2">
                        <?php echo e(__('Quick Download')); ?>

                    </h3>
                    <div class="space-y-3">
                        <div class="flex items-center justify-between">
                            <span class="text-base opacity-90"><?php echo e(__('Version')); ?></span>
                            <span class="font-semibold"><?php echo e($app->latest_version); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-base opacity-90"><?php echo e(__('Size')); ?></span>
                            <span class="font-semibold"><?php echo e($app->formatted_size); ?></span>
                        </div>
                        <div class="flex items-center justify-between">
                            <span class="text-base opacity-90"><?php echo e(__('Downloads')); ?></span>
                            <span class="font-semibold"><?php echo e($app->formatted_downloads); ?></span>
                        </div>
                    </div>
                    <a href="<?php echo e(route('download.show', $app->slug)); ?>"
                       class="mt-6 w-full inline-flex items-center justify-center px-6 py-3 bg-white text-blue-600 font-semibold rounded-xl shadow-lg hover:shadow-2xl transform hover:scale-[1.02] transition-all duration-300 focus:outline-none focus:ring-4 focus:ring-white/50">
                        <svg class="w-5 h-5 mr-2 rtl:ml-2 rtl:mr-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                        </svg>
                        <?php echo e(__('Download Now')); ?>

                    </a>
                </div>

                <!-- Related Apps -->
                <?php if($relatedApps->count() > 0): ?>
                    <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-lg p-6">
                        <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-4 border-b border-gray-200 dark:border-gray-700 pb-2">
                            <?php echo e(__('Related Apps')); ?>

                        </h3>
                        <div class="space-y-4">
                            <?php $__currentLoopData = $relatedApps->take(6); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $relatedApp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <a href="<?php echo e(route('apps.show', $relatedApp->slug)); ?>"
                                   class="flex items-center space-x-3 rtl:space-x-reverse p-3 -m-3 rounded-xl hover:bg-gray-50 dark:hover:bg-gray-700 transition-colors duration-200">
                                    <img src="<?php echo e($relatedApp->icon_url); ?>"
                                        alt="<?php echo e($relatedApp->getTranslatedName()); ?>"
                                        class="w-12 h-12 rounded-xl object-cover shadow-sm">
                                    <div class="flex-1 min-w-0">
                                        <h4 class="text-base font-medium text-gray-900 dark:text-white truncate">
                                            <?php echo e($relatedApp->getTranslatedName()); ?>

                                        </h4>
                                        <p class="text-sm text-gray-600 dark:text-gray-400">
                                            <?php echo e($relatedApp->category->getTranslatedName()); ?>

                                        </p>
                                    </div>
                                    <!-- Simple Rating Display -->
                                    <div class="flex items-center space-x-1 rtl:space-x-reverse text-yellow-500 text-sm font-semibold">
                                        <span><?php echo e(number_format($relatedApp->rating, 1)); ?></span>
                                        <svg class="w-4 h-4" fill="currentColor" viewBox="0 0 20 20"><path d="M9.049 2.927c.3-.921 1.603-.921 1.902 0l1.07 3.292a1 1 0 00.95.69h3.462c.969 0 1.371 1.24.588 1.81l-2.8 2.034a1 1 0 00-.364 1.118l1.07 3.292c.3.921-.755 1.688-1.54 1.118l-2.8-2.034a1 1 0 00-1.175 0l-2.8 2.034c-.784.57-1.838-.197-1.539-1.118l1.07-3.292a1 1 0 00-.364-1.118L2.98 8.72c-.783-.57-.38-1.81.588-1.81h3.461a1 1 0 00.951-.69l1.07-3.292z"/></svg>
                                    </div>
                                </a>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    </div>
                <?php endif; ?>

                <!-- Safety Information -->
                <div class="bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-2xl p-6">
                    <div class="flex items-start space-x-3 rtl:space-x-reverse">
                        <svg class="w-6 h-6 text-green-600 dark:text-green-400 flex-shrink-0 mt-1" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                        </svg>
                        <div>
                            <h3 class="text-sm font-semibold text-green-800 dark:text-green-200">
                                <?php echo e(__('Safe & Secure')); ?>

                            </h3>
                            <p class="text-sm text-green-700 dark:text-green-300 mt-1">
                                <?php echo e(__('This app has been scanned for viruses and malware. Download with confidence.')); ?>

                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Screenshot Modal (Lightbox) -->
    <div
        x-show="modalOpen"
        x-cloak
        x-transition:enter="ease-out duration-300"
        x-transition:enter-start="opacity-0"
        x-transition:enter-end="opacity-100"
        x-transition:leave="ease-in duration-200"
        x-transition:leave-start="opacity-100"
        x-transition:leave-end="opacity-0"
        class="fixed inset-0 z-50 overflow-y-auto bg-black bg-opacity-90 flex items-center justify-center p-4"
        @click.self="modalOpen = false"
        @keydown.escape.window="modalOpen = false"
    >
        <div class="relative w-full max-w-5xl max-h-full" @click.stop>
            <!-- Close Button -->
            <button
                @click="modalOpen = false"
                class="absolute top-4 right-4 text-white hover:text-gray-300 z-50 p-2 rounded-full bg-black/50 transition duration-150">
                <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>
            </button>

            <!-- Image -->
            <img :src="modalImage" alt="App Screenshot Preview" class="max-w-full max-h-screen object-contain mx-auto rounded-lg shadow-2xl">

            <!-- Navigation Buttons (Optional, but good for gallery feel) -->
            <template x-if="screenshots.length > 1">
                <div class="absolute inset-y-0 left-0 flex items-center">
                    <button
                        @click="prevScreenshot()"
                        class="p-4 text-white hover:text-gray-300 bg-black/50 rounded-r-lg m-4 transition duration-150">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path></svg>
                    </button>
                </div>
                <div class="absolute inset-y-0 right-0 flex items-center">
                    <button
                        @click="nextScreenshot()"
                        class="p-4 text-white hover:text-gray-300 bg-black/50 rounded-l-lg m-4 transition duration-150">
                        <svg class="w-8 h-8" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5l7 7-7 7"></path></svg>
                    </button>
                </div>
            </template>
        </div>
    </div>
</div>

<?php $__env->stopSection(); ?>

<?php $__env->startPush('scripts'); ?>
<script>
    function appShowData() {
        const screenshots = <?php echo json_encode($app->screenshots ?? [], 15, 512) ?>;

        return {
            modalOpen: false,
            modalImage: '',
            currentIndex: 0,
            screenshots,

            openModal(imageUrl, index) {
                this.modalImage = imageUrl;
                this.currentIndex = index;
                this.modalOpen = true;
                document.body.classList.add('overflow-hidden');
            },

            closeModal() {
                this.modalOpen = false;
                document.body.classList.remove('overflow-hidden');
            },

            prevScreenshot() {
                this.currentIndex = (this.currentIndex - 1 + this.screenshots.length) % this.screenshots.length;
                this.modalImage = this.screenshots[this.currentIndex];
            },

            nextScreenshot() {
                this.currentIndex = (this.currentIndex + 1) % this.screenshots.length;
                this.modalImage = this.screenshots[this.currentIndex];
            },

            init() {
                this.$watch('modalOpen', (value) => {
                    document.body.classList.toggle('overflow-hidden', value);
                });

                window.addEventListener('keydown', (e) => {
                    if (!this.modalOpen) {
                        return;
                    }

                    if (e.key === 'ArrowLeft') {
                        this.prevScreenshot();
                    } else if (e.key === 'ArrowRight') {
                        this.nextScreenshot();
                    }
                });
            },
        };
    }
</script>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/apksykyz/public_html/resources/views/apps/show.blade.php ENDPATH**/ ?>