<?php
    $supportedLocales = config('app.supported_locales', ['en']);
    $currentLocale = app()->getLocale();
    $returnUrl = request()->fullUrl();
    $wrapperClass = $wrapperClass ?? '';
    $selectClass = $selectClass ?? '';
?>

<form action="<?php echo e(route('language.switch')); ?>" method="POST" class="<?php echo e($wrapperClass); ?>">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="return_url" value="<?php echo e($returnUrl); ?>">
    <label class="sr-only"><?php echo e(__('Change language')); ?></label>
    <select
        name="locale"
        class="<?php echo e($selectClass); ?> cursor-pointer"
        aria-label="<?php echo e(__('Change language')); ?>"
        onchange="this.form.submit()"
    >
        <?php $__currentLoopData = $supportedLocales; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $supportedLocale): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <option value="<?php echo e($supportedLocale); ?>" <?php if($supportedLocale === $currentLocale): echo 'selected'; endif; ?>>
                <?php echo e(strtoupper($supportedLocale)); ?>

            </option>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </select>
</form>
<?php /**PATH /home/apksykyz/public_html/resources/views/components/language-switcher.blade.php ENDPATH**/ ?>