<?php $__env->startSection('title', $title); ?>

<?php $__env->startSection('content'); ?>
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8 md:py-12">
    <div class="mx-auto max-w-6xl px-4">

        <!-- Search Header & Stats -->
        <div class="mb-10 p-6 bg-white dark:bg-gray-800 rounded-xl shadow-lg">

            <h1 class="text-3xl font-extrabold text-gray-900 dark:text-white mb-4">
                <?php echo e(__('Search Results')); ?>

                <?php if($query): ?>
                    <span class="text-blue-600 dark:text-blue-400">"<?php echo e($query); ?>"</span>
                <?php endif; ?>
            </h1>

            <!-- Search Form (Redundant but keeps context) -->
            <form action="<?php echo e(route('apps.search')); ?>" method="GET" class="flex gap-2 mb-4">
                <input type="text" name="q" placeholder="<?php echo e(__('Search for apps, games, developers...')); ?>"
                       class="flex-1 px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500"
                       value="<?php echo e($query); ?>">
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg font-semibold hover:bg-blue-700 transition">
                    <?php echo e(__('Search')); ?>

                </button>
            </form>

            <!-- Search Stats -->
            <div class="text-sm text-gray-600 dark:text-gray-400">
                <?php if($query && $apps->total() > 0): ?>
                    <?php echo e(__('Found :count apps for ":query"', ['count' => number_format($apps->total()), 'query' => $query])); ?>

                <?php elseif($query): ?>
                    <?php echo e(__('No apps found matching your search for ":query"', ['query' => $query])); ?>

                <?php else: ?>
                    <?php echo e(__('Enter a search term above to find apps')); ?>

                <?php endif; ?>
            </div>
        </div>

        <!-- Search Results Grid -->
        <?php if($query && $apps->count() > 0): ?>
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-10">
            <?php $__currentLoopData = $apps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                
                <?php if (isset($component)) { $__componentOriginal0a926ea1962249f96912dda436e64d97 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal0a926ea1962249f96912dda436e64d97 = $attributes; } ?>
<?php $component = Illuminate\View\AnonymousComponent::resolve(['view' => 'components.app.list-card','data' => ['app' => $app]] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app.list-card'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\Illuminate\View\AnonymousComponent::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes(['app' => \Illuminate\View\Compilers\BladeCompiler::sanitizeComponentAttribute($app)]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal0a926ea1962249f96912dda436e64d97)): ?>
<?php $attributes = $__attributesOriginal0a926ea1962249f96912dda436e64d97; ?>
<?php unset($__attributesOriginal0a926ea1962249f96912dda436e64d97); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal0a926ea1962249f96912dda436e64d97)): ?>
<?php $component = $__componentOriginal0a926ea1962249f96912dda436e64d97; ?>
<?php unset($__componentOriginal0a926ea1962249f96912dda436e64d97); ?>
<?php endif; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>

        <!-- Pagination -->
        <div class="flex justify-center mt-8">
            <?php echo e($apps->links()); ?>

        </div>

        <?php elseif($query): ?>
        <!-- No Results Found State -->
        <div class="text-center py-20 bg-white dark:bg-gray-800 rounded-xl shadow-lg">
            <div class="text-7xl mb-4 text-orange-500">😔</div>
            <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e(__('No results found')); ?></h3>
            <p class="text-gray-600 dark:text-gray-400 max-w-lg mx-auto"><?php echo e(__('Try searching for a different term or check your spelling.')); ?></p>
        </div>
        <?php else: ?>
        <!-- Initial State (No search term entered yet) -->
        <div class="text-center py-20 bg-white dark:bg-gray-800 rounded-xl shadow-lg">
            <div class="text-7xl mb-4 text-blue-500">🔍</div>
            <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2"><?php echo e(__('Start searching')); ?></h3>
            <p class="text-gray-600 dark:text-gray-400 max-w-lg mx-auto"><?php echo e(__('Enter a search term above to quickly find the apps and games you are looking for.')); ?></p>
        </div>
        <?php endif; ?>
    </div>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/apksykyz/public_html/resources/views/apps/search.blade.php ENDPATH**/ ?>