<?php
    // دعم لأسماء مختلفة للقوائم: $drafts أو $apps أو $results
    $list = $drafts ?? $apps ?? $results ?? [];
?>

<div class="table-responsive">
    <table class="table table-hover">
        <thead>
        <tr>
            <th>App Name</th>
            <th>Package Name</th>
            <th>Developer</th>
            <th>Version</th>
            <th>Size</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        <?php $__empty_1 = true; $__currentLoopData = $list; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
            <tr>
                <td><?php echo e($item['name'] ?? 'N/A'); ?></td>
                <td><?php echo e($item['package_name'] ?? 'N/A'); ?></td>
                <td><?php echo e($item['developer'] ?? 'N/A'); ?></td>
                <td><?php echo e($item['latest_version'] ?? 'N/A'); ?></td>
                <td><?php echo e(number_format((($item['size'] ?? 0) / 1048576), 2)); ?> MB</td>
                <td>
                    <form method="POST" action="<?php echo e(route('platform.apk-import.publish')); ?>" style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <input type="hidden" name="app_data" value='<?php echo json_encode($item, 15, 512) ?>'>
                        <button type="submit" class="btn btn-sm btn-success">
                            <i class="icon-check"></i> Publish
                        </button>
                    </form>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
            <tr>
                <td colspan="6" class="text-center text-muted">
                    No apps found. Use "Search & Scrape" above.
                </td>
            </tr>
        <?php endif; ?>
        </tbody>
    </table>
</div><?php /**PATH /home/apksykyz/public_html/resources/views/orchid/apk-import-table.blade.php ENDPATH**/ ?>