<?php $__env->startSection('title', $title ?? __('Games')); ?>

<?php $__env->startSection('content'); ?>
    <section class="bg-gradient-to-br from-slate-900 via-purple-800 to-indigo-700 py-16 text-white">
        <div class="mx-auto max-w-5xl px-6">
            <p class="text-sm font-semibold uppercase tracking-wide text-white/80"><?php echo e(__('Arcade ready')); ?></p>
            <h1 class="mt-2 text-4xl font-bold"><?php echo e($title ?? __('Popular Games')); ?></h1>
            <p class="mt-3 text-white/80"><?php echo e(__('Download the best games for your device, from casual fun to AAA adventures.')); ?></p>
        </div>
    </section>

    <section class="mx-auto max-w-6xl px-6 py-14">
        <?php if($games->count()): ?>
            <div class="grid gap-6 md:grid-cols-2 lg:grid-cols-3">
                <?php $__currentLoopData = $games; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="rounded-2xl border border-slate-100 bg-white/90 shadow-sm transition hover:-translate-y-1 hover:shadow-lg dark:border-slate-800 dark:bg-slate-900/70">
                        <div class="relative h-44 overflow-hidden rounded-t-2xl bg-gradient-to-r from-indigo-500 to-purple-500">
                            <img src="<?php echo e($app->icon_url); ?>" alt="<?php echo e($app->getTranslatedName()); ?>" class="absolute inset-0 h-full w-full object-cover opacity-80">
                            <div class="absolute inset-0 bg-gradient-to-t from-slate-900/80"></div>
                            <div class="relative flex h-full flex-col justify-end gap-2 p-4">
                                <span class="inline-flex items-center gap-1 rounded-full bg-white/20 px-3 py-1 text-xs font-semibold">
                                    <?php echo e($app->category?->getTranslatedName()); ?>

                                </span>
                                <h3 class="text-xl font-bold"><?php echo e($app->getTranslatedName()); ?></h3>
                            </div>
                        </div>
                        <div class="p-5">
                            <p class="line-clamp-3 text-sm text-slate-600 dark:text-slate-400"><?php echo e(Str::limit($app->getTranslatedDescription(), 150)); ?></p>
                            <div class="mt-4 flex items-center justify-between text-xs text-slate-500 dark:text-slate-400">
                                <span>★ <?php echo e(number_format($app->rating, 1)); ?></span>
                                <span><?php echo e($app->formatted_downloads); ?> <?php echo e(__('Downloads')); ?></span>
                            </div>
                            <a href="<?php echo e(route('download.show', $app->slug)); ?>" class="mt-5 block rounded-xl bg-indigo-600 py-3 text-center text-sm font-semibold text-white hover:bg-indigo-500"><?php echo e(__('Download')); ?></a>
                        </div>
                    </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>

            <div class="mt-10 flex justify-center">
                <?php echo e($games->links()); ?>

            </div>
        <?php else: ?>
            <div class="rounded-3xl border border-slate-100 bg-white/80 p-12 text-center dark:border-slate-800 dark:bg-slate-900/60">
                <p class="text-4xl">🎮</p>
                <h2 class="mt-4 text-2xl font-bold text-slate-900 dark:text-white"><?php echo e(__('No games found at the moment.')); ?></h2>
                <p class="mt-2 text-slate-500 dark:text-slate-400"><?php echo e(__('Check back later for new releases.')); ?></p>
            </div>
        <?php endif; ?>
    </section>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/apksykyz/public_html/resources/views/apps/games.blade.php ENDPATH**/ ?>