<?php $__env->startSection('title', $title ?? config('app.name')); ?>

<?php $__env->startSection('meta_description', __('Android app repository')); ?>

<?php $__env->startSection('content'); ?>
    <?php
        // View receives computed values from the controller: 
        // $totalDownloads, $featuredCount, $categoriesCount, $hasImportSources, and arrays/collections.
        // Ensure a safe default if the cache was created before controller added these keys.
        $hasImportSources = isset($hasImportSources) ? $hasImportSources : (!empty($importSources ?? []));
    ?>

    
    <section class="hero-section">
        <div class="hero-grid">
            
            <div class="space-y-6">
                <div>
                    <h1 class="text-4xl font-bold text-accent mb-4">
                        <?php echo e(__('Welcome to :app', ['app' => config('app.name')])); ?>

                    </h1>
                    <p class="text-lg text-muted">
                        <?php echo e(__('Discover and download the latest Android apps and games')); ?>

                    </p>
                </div>

                <div class="stats-grid">
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent"><?php echo e(number_format($totalDownloads ?? 0)); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Total Downloads')); ?></span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent"><?php echo e(number_format($featuredCount ?? 0)); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Featured Apps')); ?></span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent"><?php echo e(number_format($categoriesCount ?? 0)); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Categories')); ?></span>
                    </div>
                </div>
            </div>

            
            <div class="connected-card">
                <div class="flex items-start justify-between gap-2">
                    <div>
                        <p class="section-heading"><?php echo e(__('Live feed')); ?></p>
                        <h3 class="section-title text-lg">
                            <?php echo e(__('Fresh arrivals')); ?>

                        </h3>
                    </div>
                    <span class="badge">
                        <?php echo e(__('Updated :time', ['time' => now()->diffForHumans(null, true)])); ?>

                    </span>
                </div>

                <ul class="mt-4 space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $latestApps->take(4); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="flex items-center gap-3 rounded-2xl border border-[#dfe6f0] p-3">
                            <img
                                src="<?php echo e($app->icon_url); ?>"
                                alt="<?php echo e($app->getTranslatedName()); ?>"
                                class="h-12 w-12 rounded-2xl object-cover shadow-sm"
                                loading="lazy"
                            >
                            <div class="min-w-0 flex-1">
                                <a
                                    href="<?php echo e(route('apps.show', $app->slug)); ?>"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    <?php echo e($app->getTranslatedName()); ?>

                                </a>
                                <p class="text-muted text-xs truncate">
                                    <?php echo e($app->category?->getTranslatedName() ?? __('Uncategorized')); ?>

                                </p>
                            </div>
                            <div class="text-right text-xs text-muted">
                                <div><?php echo e($app->latest_version); ?></div>
                                <div><?php echo e($app->updated_at?->diffForHumans()); ?></div>
                            </div>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="text-sm text-muted">
                            <?php echo e(__('No apps found in the live feed yet.')); ?>

                        </li>
                    <?php endif; ?>
                </ul>

                <div class="mt-4">
                    <p class="section-heading">
                        <?php echo e(__('Connected feeds')); ?>

                    </p>

                    <?php if($hasImportSources): ?>
                        <div class="mt-3 flex flex-wrap gap-2">
                            <?php $__currentLoopData = $importSources; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sourceName): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <span class="badge">
                                    <?php echo e($sourceName); ?>

                                </span>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>
                    <?php else: ?>
                        <p class="mt-2 footer-muted text-sm">
                            <?php echo e(__('Plug in your first import source to initialize live syncing.')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>
        </div>
    </section>

    
    <section class="page-section">
        <div class="text-center mb-8">
            <h2 class="text-3xl font-bold text-accent mb-3">
                <?php echo e(__('Multi-Source Pipeline')); ?>

            </h2>
            <p class="text-muted text-lg">
                <?php echo e(__('Automated app importing from multiple trusted sources')); ?>

            </p>
        </div>

        <div class="section-grid">
            <div class="feature-card">
                <div class="text-4xl mb-4">🔄</div>
                <h3 class="text-xl font-semibold text-accent mb-2"><?php echo e(__('Auto Sync')); ?></h3>
                <p class="text-muted text-sm">
                    <?php echo e(__('Automatically import and update apps from connected sources')); ?>

                </p>
            </div>

            <div class="feature-card">
                <div class="text-4xl mb-4">⚡</div>
                <h3 class="text-xl font-semibold text-accent mb-2"><?php echo e(__('Fast Updates')); ?></h3>
                <p class="text-muted text-sm">
                    <?php echo e(__('Get the latest app versions as soon as they are available')); ?>

                </p>
            </div>

            <div class="feature-card">
                <div class="text-4xl mb-4">🔒</div>
                <h3 class="text-xl font-semibold text-accent mb-2"><?php echo e(__('Secure')); ?></h3>
                <p class="text-muted text-sm">
                    <?php echo e(__('All apps are scanned and verified before publishing')); ?>

                </p>
            </div>
        </div>
    </section>

    
    <section class="page-section">
        <div class="flex flex-col gap-3 mb-6">
            <h2 class="text-3xl font-bold text-accent">
                <?php echo e(__('Featured Apps')); ?>

            </h2>
            <p class="text-muted text-lg">
                <?php echo e(__('Hand-picked quality applications for you')); ?>

            </p>
        </div>

        <div class="section-footer mb-6">
            <a href="<?php echo e(route('apps.latest')); ?>" class="btn-secondary">
                <?php echo e(__('View All Apps')); ?> →
            </a>
        </div>

        <div class="section-grid mt-4">
            <?php $__empty_1 = true; $__currentLoopData = $featuredApps; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <article class="app-card">
                    <div class="flex items-center gap-4">
                        <img
                            src="<?php echo e($app->icon_url); ?>"
                            alt="<?php echo e($app->getTranslatedName()); ?>"
                            class="h-16 w-16 rounded-2xl object-cover shadow-sm"
                            loading="lazy"
                        >
                        <div class="min-w-0 flex-1">
                            <a
                                href="<?php echo e(route('apps.show', $app->slug)); ?>"
                                class="text-lg font-semibold text-accent line-clamp-1"
                            >
                                <?php echo e($app->getTranslatedName()); ?>

                            </a>
                            <p class="text-muted text-sm line-clamp-1">
                                <?php echo e($app->developer); ?>

                            </p>
                        </div>
                    </div>

                    <p class="mt-3 text-muted text-sm line-clamp-3">
                        <?php echo e(Str::limit($app->getTranslatedDescription(), 160)); ?>

                    </p>

                    <div class="app-actions mt-3">
                        <?php if(!is_null($app->rating)): ?>
                            <span class="badge">
                                ★ <?php echo e(number_format($app->rating, 1)); ?>

                            </span>
                        <?php endif; ?>
                        <span class="text-muted text-sm">
                            <?php echo e($app->formatted_downloads); ?> <?php echo e(__('Downloads')); ?>

                        </span>
                    </div>

                    <div class="app-actions mt-3">
                        <a href="<?php echo e(route('apps.show', $app->slug)); ?>" class="btn-secondary text-center text-sm">
                            <?php echo e(__('Details')); ?>

                        </a>
                        <a href="<?php echo e(route('download.show', $app->slug)); ?>" class="btn-primary text-center text-sm">
                            <?php echo e(__('Download')); ?>

                        </a>
                    </div>
                </article>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                <p class="text-muted col-span-full text-center py-8">
                    <?php echo e(__('No featured apps yet.')); ?>

                </p>
            <?php endif; ?>
        </div>
    </section>

    
    <section class="page-section">
        <div class="glass-panel">
            <div class="flex flex-col gap-1 mb-6">
                <h2 class="text-3xl font-bold text-accent">
                    <?php echo e(__('Top Categories')); ?>

                </h2>
                <p class="text-muted text-lg">
                    <?php echo e(__('Browse apps by category')); ?>

                </p>
            </div>

            <div class="section-grid mt-6">
                <?php $__empty_1 = true; $__currentLoopData = $topCategories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $category): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <a
                        href="<?php echo e(route('apps.category', $category->slug)); ?>"
                        class="feature-card"
                    >
                        <div>
                            <p class="text-lg font-semibold text-accent line-clamp-1">
                                <?php echo e($category->getTranslatedName()); ?>

                            </p>
                            <p class="text-muted text-sm">
                                <?php echo e(number_format($category->apps_count)); ?> <?php echo e(__('apps available')); ?>

                            </p>
                        </div>
                        <span class="text-muted text-3xl">
                            <?php echo $__env->make('components.category-icon', [
                                'slug'  => $category->slug,
                                'color' => '',
                            ], array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>
                        </span>
                    </a>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <p class="text-sm text-muted col-span-full text-center py-8">
                        <?php echo e(__('No categories available yet.')); ?>

                    </p>
                <?php endif; ?>
            </div>
        </div>
    </section>

    
    <section class="page-section">
        <div class="grid gap-6 lg:grid-cols-2">
            
            <div class="feature-card">
                <div class="flex items-center justify-between gap-2 mb-4">
                    <div>
                        <h3 class="text-xl font-bold text-accent">
                            <?php echo e(__('Latest Updates')); ?>

                        </h3>
                        <p class="text-muted text-sm">
                            <?php echo e(__('Recently updated apps')); ?>

                        </p>
                    </div>
                </div>

                <div class="mt-4 space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $latestApps->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <div class="flex items-center justify-between gap-3">
                            <div class="min-w-0">
                                <a
                                    href="<?php echo e(route('apps.show', $app->slug)); ?>"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    <?php echo e($app->getTranslatedName()); ?>

                                </a>
                                <p class="text-muted text-xs line-clamp-2">
                                    <?php echo e(Str::limit($app->getTranslatedDescription(), 90)); ?>

                                </p>
                            </div>
                            <span class="shrink-0 text-xs text-muted">
                                <?php echo e($app->updated_at?->diffForHumans()); ?>

                            </span>
                        </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <p class="text-sm text-muted">
                            <?php echo e(__('No recent updates yet.')); ?>

                        </p>
                    <?php endif; ?>
                </div>
            </div>

            
            <div class="connected-card">
                <div class="flex items-center justify-between gap-2 mb-4">
                    <div>
                        <h3 class="text-xl font-bold text-accent">
                            <?php echo e(__('Most Downloaded')); ?>

                        </h3>
                        <p class="text-muted text-sm">
                            <?php echo e(__('Popular apps this month')); ?>

                        </p>
                    </div>
                </div>

                <ul class="mt-4 space-y-3">
                    <?php $__empty_1 = true; $__currentLoopData = $mostDownloadedApps->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $app): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                        <li class="flex items-center justify-between gap-3">
                            <div class="min-w-0">
                                <a
                                    href="<?php echo e(route('apps.show', $app->slug)); ?>"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    <?php echo e($app->getTranslatedName()); ?>

                                </a>
                                <p class="text-muted text-xs truncate">
                                    <?php echo e($app->category?->getTranslatedName() ?? __('Uncategorized')); ?>

                                </p>
                            </div>
                            <span class="shrink-0 text-sm font-semibold text-muted">
                                <?php echo e($app->formatted_downloads); ?>

                            </span>
                        </li>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                        <li class="text-sm text-muted">
                            <?php echo e(__('No popular apps to show yet.')); ?>

                        </li>
                    <?php endif; ?>
                </ul>
            </div>
        </div>
    </section>

    
    <section class="page-section">
        <div class="grid gap-6 lg:grid-cols-2">
            <div class="connected-card">
                <h3 class="text-xl font-bold text-accent mb-2">
                    <?php echo e(__('Import Sources')); ?>

                </h3>
                <p class="text-muted text-sm mb-4">
                    <?php echo e(__('Connected app sources and feeds')); ?>

                </p>

                <div class="stats-grid mt-4">
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent"><?php echo e(count($importSources ?? [])); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Active Sources')); ?></span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent"><?php echo e(number_format($totalDownloads ?? 0)); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Total Downloads')); ?></span>
                    </div>
                </div>
            </div>

            <div class="connected-card">
                <h3 class="text-xl font-bold text-accent mb-2">
                    <?php echo e(__('Automation')); ?>

                </h3>
                <p class="text-muted text-sm mb-4">
                    <?php echo e(__('Automated processes and updates')); ?>

                </p>

                <div class="stats-grid mt-4">
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent">24/7</strong>
                        <span class="text-sm text-muted"><?php echo e(__('Monitoring')); ?></span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent"><?php echo e(__('Auto')); ?></strong>
                        <span class="text-sm text-muted"><?php echo e(__('Updates')); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/apksykyz/public_html/resources/views/homepage.blade.php ENDPATH**/ ?>