#!/usr/bin/env bash
set -euo pipefail

# Tidy Blade templates: convert tabs to 2 spaces, remove trailing whitespace,
# ensure LF line endings, and collapse multiple blank lines to max two.

ROOT_DIR="$(cd "$(dirname "$0")/.." && pwd)"
cd "$ROOT_DIR"

FILES=$(find resources/views -type f -name "*.blade.php")
if [ -z "$FILES" ]; then
  echo "No blade files found."
  exit 0
fi

for f in $FILES; do
  echo "Tidying $f"
  # Normalize line endings to LF, replace tabs with 2 spaces, remove trailing spaces
  # Then collapse more than two consecutive blank lines to two
  awk 'BEGIN{ORS="\n"} {gsub("\t","  "); sub("[ \t]+$",""); print}' "$f" \
    | perl -0777 -pe 's/\r\n?/\n/g; s/\n{3,}/\n\n/g' > "$f.tidy"
  mv "$f.tidy" "$f"
done

echo "Done. You may want to review changes and commit them."
