#!/usr/bin/env bash
# Run this script on the host (not inside restricted containers) to install tools and build the project.
# Usage: sudo bash scripts/setup_and_build.sh

set -o errexit
set -o pipefail
set -o nounset

ROOT_DIR="$(cd "$(dirname "$0")/.." && pwd)"
cd "$ROOT_DIR"

echo "== Update apt and install prerequisites =="
apt-get update -y
apt-get install -y curl ca-certificates gnupg build-essential apt-transport-https lsb-release software-properties-common

echo "== Install Node.js 18 (NodeSource) =="
curl -fsSL https://deb.nodesource.com/setup_18.x | bash -
apt-get install -y nodejs

echo "== Install PHP CLI and extensions =="
apt-get install -y php-cli php-xml php-mbstring php-zip unzip

echo "== Install Composer =="
php -r "copy('https://getcomposer.org/installer','composer-setup.php');"
EXPECTED_SIG=$(curl -sS https://composer.github.io/installer.sig)
ACTUAL_SIG=$(php -r "echo hash_file('sha384', 'composer-setup.php');")
if [ "$EXPECTED_SIG" != "$ACTUAL_SIG" ]; then
  echo "Composer installer corrupt" >&2
  rm composer-setup.php
  exit 1
fi
php composer-setup.php --install-dir=/usr/local/bin --filename=composer
rm composer-setup.php

echo "== Install Node dependencies and format/build =="
if [ -f package.json ]; then
  npm ci --no-audit --prefer-offline
  npm run format || true
  npm run build || true
fi

echo "== Composer install and Laravel optimizations =="
if [ -f composer.json ]; then
  composer install --no-dev --optimize-autoloader
fi

if [ -f artisan ]; then
  php artisan config:cache || true
  php artisan route:cache || true
  php artisan view:cache || true
  php artisan optimize || true
fi

echo "== Run tests (if available) =="
if [ -f ./vendor/bin/phpunit ]; then
  ./vendor/bin/phpunit --colors=always || true
fi

echo "== Done =="
