#!/usr/bin/env bash
# Run php -l across all PHP files in the project
# Exits with non-zero status if any file contains syntax errors.

set -euo pipefail

if ! command -v php >/dev/null 2>&1; then
  echo "php CLI not found. Install PHP to run linting (php -v to check)."
  exit 2
fi

echo "Running php -l across project files..."
errors=0
while IFS= read -r -d '' file; do
  if ! php -l "$file" >/dev/null 2>&1; then
    echo "SYNTAX ERROR in: $file"
    php -l "$file" || true
    errors=$((errors+1))
  fi
done < <(find . -type f -name '*.php' -print0)

if [ "$errors" -gt 0 ]; then
  echo "Done: $errors files have syntax errors."
  exit 1
fi

echo "All PHP files passed php -l syntax check."
exit 0
