#!/usr/bin/env bash
set -euo pipefail

# Prepare a deployable tar.gz archive of the project root.
# Usage: bash scripts/prepare_deploy.sh [output-file]

ROOT_DIR="$(cd "$(dirname "$0")/.." && pwd)"
OUT_FILE="${1:-deploy-package.tar.gz}"

cd "$ROOT_DIR"

echo "Cleaning logs and caches..."
rm -f storage/logs/*.log || true
rm -rf storage/framework/cache/data/* || true
rm -rf storage/framework/views/* || true

echo "Setting loose permissions for storage and cache (owner unchanged)..."
chmod -R u+rwX,go+rX,go-w storage bootstrap/cache || true

echo "Creating tarball $OUT_FILE (excluding .git, node_modules, tests)..."
tar --exclude-vcs --exclude='./node_modules' --exclude='./tests' --exclude='./.github' --exclude='./.env' -czf "$OUT_FILE" .

echo "Archive ready: $ROOT_DIR/$OUT_FILE"
