#!/usr/bin/env bash
set -euo pipefail

# Post-deploy steps to run on the server after uploading project files.
# This script does not use sudo. Run it as the user who can run PHP/Composer.

ROOT_DIR="$(cd "$(dirname "$0")/.." && pwd)"
cd "$ROOT_DIR"

echo "Running post-deploy tasks in $ROOT_DIR"

if command -v composer >/dev/null 2>&1; then
  echo "Installing composer dependencies (no-dev)"
  composer install --no-interaction --no-dev --prefer-dist --optimize-autoloader
else
  echo "Composer not found — skipping composer install. If vendor/ is missing, install Composer first." >&2
fi

if [ -f artisan ]; then
  echo "Generating app key (if missing)"
  php artisan key:generate --ansi || true

  echo "Caching config, routes, views"
  php artisan config:cache || true
  php artisan route:cache || true
  php artisan view:cache || true
  php artisan optimize || true
else
  echo "artisan not found — ensure you are in the project root" >&2
fi

echo "Clearing runtime caches"
php artisan cache:clear || true

echo "Post-deploy complete. Verify web server points to the 'public/' directory and storage permissions are set."
