Image optimization helper
=========================

This folder contains `optimize_images.py` — a lightweight helper that uses Pillow to estimate and
produce optimized image outputs from the repository images.

Usage
-----

1. Install Pillow (only required if not already available):

```bash
python3 -m pip install --user pillow
```


2. Dry-run to see estimated savings (recommended):

```bash
python3 scripts/optimize_images.py --dry-run
```

3. Write optimized images to `public/images-optimized`:

```bash
python3 scripts/optimize_images.py --output public/images-optimized
```

4. Overwrite originals in-place (creates `.bak` backups if none exist):

```bash
python3 scripts/optimize_images.py --inplace
```

Note: Run `--inplace` in a branch or backup your files first; the GitHub Action runs the optimizer on a branch and opens a PR so you can review changes before merging.

Notes
-----
- The script does not overwrite originals. It writes optimized outputs to the chosen `--output` dir.
- For best production-ready compression, consider running platform tools like `jpegoptim`, `pngquant`, or a CI image-optimizer action.
