<?php

declare(strict_types=1);

use App\Orchid\Screens\APKImportScreen;
use App\Orchid\Screens\DashboardScreen;
use App\Orchid\Screens\SettingsScreen;
use App\Orchid\Screens\ReportsScreen;
use App\Orchid\Screens\PlatformScreen;
use App\Orchid\Screens\Role\RoleEditScreen;
use App\Orchid\Screens\Role\RoleListScreen;
use App\Orchid\Screens\User\UserEditScreen;
use App\Orchid\Screens\User\UserListScreen;
use App\Orchid\Screens\User\UserProfileScreen;
use Illuminate\Support\Facades\Route;
use Tabuna\Breadcrumbs\Trail;

// Entry point
Route::screen('/', DashboardScreen::class)
    ->name('platform.index')
    ->breadcrumbs(fn (Trail $trail) => $trail->push('Overview'));

// Dashboard
Route::screen('/dashboard', DashboardScreen::class)
    ->name('platform.dashboard')
    ->breadcrumbs(fn (Trail $trail) => $trail->push('Dashboard'));

// Reports
Route::screen('/reports', ReportsScreen::class)
    ->name('platform.reports')
    ->breadcrumbs(fn (Trail $trail) => $trail->push('Reports'));

// Settings
Route::screen('/settings', SettingsScreen::class)
    ->name('platform.settings')
    ->breadcrumbs(fn (Trail $trail) => $trail->push('Settings'));

// Main
Route::screen('/main', PlatformScreen::class)
    ->name('platform.main');

// Profile
Route::screen('profile', UserProfileScreen::class)
    ->name('platform.profile')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.index')->push('Profile'));

// Users
Route::screen('users/{user}/edit', UserEditScreen::class)
    ->name('platform.systems.users.edit')
    ->breadcrumbs(fn (Trail $trail, $user) => $trail->parent('platform.systems.users')->push('Edit'));

Route::screen('users/create', UserEditScreen::class)
    ->name('platform.systems.users.create')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.systems.users')->push('Create'));

Route::screen('users', UserListScreen::class)
    ->name('platform.systems.users')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.index')->push('Users'));

// Roles
Route::screen('roles/{role}/edit', RoleEditScreen::class)
    ->name('platform.systems.roles.edit')
    ->breadcrumbs(fn (Trail $trail, $role) => $trail->parent('platform.systems.roles')->push('Edit'));

Route::screen('roles/create', RoleEditScreen::class)
    ->name('platform.systems.roles.create')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.systems.roles')->push('Create'));

Route::screen('roles', RoleListScreen::class)
    ->name('platform.systems.roles')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.index')->push('Roles'));

// APK Import (Admin)
Route::screen('apk-import', APKImportScreen::class)
    ->name('platform.apk-import')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.index')->push('Import APKs'));

Route::post('apk-import/publish', [APKImportScreen::class, 'publishApp'])
    ->name('platform.apk-import.publish');

Route::post('apk-import/bulk-publish', [APKImportScreen::class, 'bulkPublish'])
    ->name('platform.apk-import.bulkPublish');

// Export ZIP (Admin)
Route::screen('export-zip', \App\Orchid\Screens\ExportZipScreen::class)
    ->name('platform.export-zip')
    ->breadcrumbs(fn (Trail $trail) => $trail->parent('platform.index')->push('Export ZIP'));

// Download ZIP archive (protected)
Route::get('download-zip/{file}', [\App\Http\Controllers\DownloadZipController::class, 'download'])
    ->name('platform.download-zip');