<?php echo '<?xml version="1.0" encoding="UTF-8"?>'; ?>
<urlset xmlns="http://www.sitemaps.org/schemas/sitemap/0.9">

    <!-- Homepage -->
    <url>
        <loc>{{ route('home') }}</loc>
        <lastmod>{{ now()->toAtomString() }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>1.0</priority>
    </url>

    <!-- Categories -->
    @foreach ($categories as $category)
    <url>
        {{-- استخدام e() لضمان الهروب الآمن (Escaping) داخل XML --}}
        <loc>{{ e(route('apps.category', $category->slug)) }}</loc>
        <lastmod>{{ $category->updated_at?->toAtomString() ?? now()->toAtomString() }}</lastmod>
        <changefreq>weekly</changefreq>
        <priority>0.8</priority>
    </url>
    @endforeach

    <!-- Apps -->
    @foreach ($apps as $app)
    <url>
        {{-- استخدام e() لضمان الهروب الآمن (Escaping) داخل XML --}}
        <loc>{{ e(route('apps.show', $app->slug)) }}</loc>
        <lastmod>{{ $app->updated_at?->toAtomString() ?? now()->toAtomString() }}</lastmod>
        <changefreq>daily</changefreq>
        <priority>0.9</priority>
    </url>
    @endforeach

</urlset>
