@extends('layouts.app')

@section('title', __('Privacy Policy'))

@section('content')
    <section class="bg-slate-900 py-16 text-white">
        <div class="mx-auto max-w-4xl px-6 text-center">
            <p class="text-sm font-semibold uppercase tracking-wide text-white/70">{{ __('Our commitment to your data') }}</p>
            <h1 class="mt-2 text-4xl font-bold">{{ __('Privacy Policy') }}</h1>
            <p class="mt-3 text-white/70">{{ __('We protect your information and keep your downloads safe.') }}</p>
        </div>
    </section>

    <section class="mx-auto max-w-4xl px-6 py-14">
        <article class="space-y-10 rounded-3xl border border-slate-100 bg-white p-8 shadow-sm dark:border-slate-800 dark:bg-slate-900">
            <div>
                <h2 class="text-xl font-bold text-slate-900 dark:text-white">{{ __('1. Information We Collect') }}</h2>
                <p class="mt-3 text-slate-600 dark:text-slate-400">
                    {{ __('We may collect personal information such as your name, email address, device information, and usage data to improve our services and keep you safe.') }}
                </p>
            </div>
            <div>
                <h2 class="text-xl font-bold text-slate-900 dark:text-white">{{ __('2. How We Use Your Information') }}</h2>
                <p class="mt-3 text-slate-600 dark:text-slate-400">
                    {{ __('The information collected allows us to personalize the experience, send important communications, and provide accurate download statistics.') }}
                </p>
            </div>
            <div>
                <h2 class="text-xl font-bold text-slate-900 dark:text-white">{{ __('3. Protection of Your Information') }}</h2>
                <p class="mt-3 text-slate-600 dark:text-slate-400">
                    {{ __('We use industry-standard encryption and secure storage to keep your data safe. Access is limited to authorized personnel only.') }}
                </p>
            </div>
        </article>
    </section>
@endsection
