@extends('layouts.app')

@section('title', __('About Us'))

@section('content')
    <section class="bg-gradient-to-r from-slate-900 via-indigo-900 to-purple-800 py-16 text-white">
        <div class="mx-auto max-w-5xl px-6 text-center">
            <p class="text-sm font-semibold uppercase tracking-wide text-white/80">{{ __('Our story') }}</p>
            <h1 class="mt-2 text-4xl font-bold">{{ __('About APK Center') }}</h1>
            <p class="mt-3 text-white/80">{{ __('We are a small distributed team focused on curating the safest Android downloads for millions of users worldwide.') }}</p>
        </div>
    </section>

    <section class="mx-auto max-w-5xl px-6 py-14">
        <div class="grid gap-6 md:grid-cols-3">
            <div class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-4xl font-bold text-indigo-600 dark:text-indigo-300">2018</p>
                <p class="mt-2 text-sm font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">{{ __('Founded') }}</p>
                <p class="mt-2 text-slate-600 dark:text-slate-400">{{ __('Started as a tiny side-project by two friends in Dubai.') }}</p>
            </div>
            <div class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-4xl font-bold text-indigo-600 dark:text-indigo-300">2M+</p>
                <p class="mt-2 text-sm font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">{{ __('Monthly users') }}</p>
                <p class="mt-2 text-slate-600 dark:text-slate-400">{{ __('Our catalog powers millions of safe downloads every month.') }}</p>
            </div>
            <div class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-4xl font-bold text-indigo-600 dark:text-indigo-300">28</p>
                <p class="mt-2 text-sm font-semibold uppercase tracking-wide text-slate-500 dark:text-slate-400">{{ __('Team members') }}</p>
                <p class="mt-2 text-slate-600 dark:text-slate-400">{{ __('Engineers, editors, and security experts across 6 countries.') }}</p>
            </div>
        </div>

        <div class="mt-12 space-y-8 text-slate-600 dark:text-slate-300">
            <div>
                <h2 class="text-2xl font-semibold text-slate-900 dark:text-white">{{ __('What we believe in') }}</h2>
                <p class="mt-3">{{ __('Trust, transparency, and performance. Every APK is scanned, verified, and tagged by our editorial team before it appears on the site.') }}</p>
            </div>
            <div>
                <h2 class="text-2xl font-semibold text-slate-900 dark:text-white">{{ __('How we operate') }}</h2>
                <p class="mt-3">{{ __('We maintain a private cluster of malware scanners, track upstream developer updates, and run human testing sprints to ensure safe downloads.') }}</p>
            </div>
        </div>
    </section>
@endsection
