@php
    // دعم لأسماء مختلفة للقوائم: $drafts أو $apps أو $results
    $list = $drafts ?? $apps ?? $results ?? [];
@endphp

<div class="table-responsive">
    <table class="table table-hover">
        <thead>
        <tr>
            <th>App Name</th>
            <th>Package Name</th>
            <th>Developer</th>
            <th>Version</th>
            <th>Size</th>
            <th>Action</th>
        </tr>
        </thead>
        <tbody>
        @forelse($list as $item)
            <tr>
                <td>{{ $item['name'] ?? 'N/A' }}</td>
                <td>{{ $item['package_name'] ?? 'N/A' }}</td>
                <td>{{ $item['developer'] ?? 'N/A' }}</td>
                <td>{{ $item['latest_version'] ?? 'N/A' }}</td>
                <td>{{ number_format((($item['size'] ?? 0) / 1048576), 2) }} MB</td>
                <td>
                    <form method="POST" action="{{ route('platform.apk-import.publish') }}" style="display:inline;">
                        @csrf
                        <input type="hidden" name="app_data" value='@json($item)'>
                        <button type="submit" class="btn btn-sm btn-success">
                            <i class="icon-check"></i> Publish
                        </button>
                    </form>
                </td>
            </tr>
        @empty
            <tr>
                <td colspan="6" class="text-center text-muted">
                    No apps found. Use "Search & Scrape" above.
                </td>
            </tr>
        @endforelse
        </tbody>
    </table>
</div>