<!DOCTYPE html>
<html lang="{{ str_replace('_', '-', $locale) }}" dir="{{ $isRtl ? 'rtl' : 'ltr' }}">
<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">
    <meta name="dark-mode-toggle-url" content="{{ route('dark-mode.toggle') }}">
    
    <title>
        @hasSection('title')
            @yield('title') | {{ $appName }}
        @else
            {{ $appName }}
        @endif
    </title>
    
    <meta name="description" content="@yield('meta_description', __('Download the latest Android apps and games for free. Safe, fast, and secure downloads.'))">

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Space+Grotesk:wght@400;500;600;700&family=Inter:wght@400;500;600&display=swap" rel="stylesheet">

    <!-- Styles & Scripts -->
    @vite(['resources/css/app.css', 'resources/js/app.js'])
    @stack('head')
<link rel="stylesheet" href="/custom-style.css">
</head>
<body @class(['antialiased', 'dark' => $isDarkMode])>
    <div class="site-shell">
        {{-- HEADER --}}
        <header class="site-header">
            <div class="site-header-inner">
                {{-- Logo --}}
                <a href="{{ route('home') }}" class="site-logo">
                    @include('components.digital-logo')
                    <div>
                        <p class="logo-text text-xl">{{ $appName }}</p>
                        <p class="logo-sub">{{ __('apks.center') }}</p>
                    </div>
                </a>

                {{-- Desktop Navigation --}}
                <nav class="nav-links hidden lg:flex" aria-label="{{ __('Primary navigation') }}">
                    @foreach ($navLinks as $link)
                        <a 
                            href="{{ $link['route'] }}"
                            @class(['nav-link', 'nav-link-active' => $link['active']])
                            @if($link['active']) aria-current="page" @endif
                        >
                            {{ $link['label'] }}
                        </a>
                    @endforeach
                </nav>

                {{-- Desktop Actions --}}
                <div class="site-actions hidden lg:flex">
                    {{-- Search --}}
                    <form action="{{ route('apps.search') }}" method="GET" class="site-search relative">
                        <input
                            type="text"
                            name="q"
                            value="{{ request('q') }}"
                            placeholder="{{ __('Search apps...') }}"
                            aria-label="{{ __('Search apps') }}"
                        >
                        <span class="pointer-events-none">
                            <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                <path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.2-5.2m0 0a7.5 7.5 0 1 0-10.6-10.6 7.5 7.5 0 0 0 10.6 10.6z"/>
                            </svg>
                        </span>
                    </form>

                    {{-- Language Switcher --}}
                    <div class="language-switcher inline-flex items-center gap-2">
                        <span class="text-muted uppercase tracking-[0.3em] text-xs">{{ strtoupper($locale) }}</span>
                        @include('components.language-switcher', [
                            'wrapperClass' => 'inline-flex items-center',
                            'selectClass' => 'language-select',
                        ])
                    </div>

                    {{-- Dark Mode Toggle --}}
                    <button id="darkModeToggle" type="button" class="pill-button" aria-label="{{ __('Toggle dark mode') }}">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21 12.79A9 9 0 1 1 11.21 3 7 7 0 0 0 21 12.79Z"/>
                        </svg>
                        <span class="text-xs font-semibold">{{ $isDarkMode ? __('Light') : __('Dark') }}</span>
                    </button>
                </div>

                {{-- Mobile Menu Toggle --}}
                <button id="mobileMenuToggle" type="button" class="pill-button lg:hidden" aria-label="{{ __('Toggle menu') }}">
                    <svg class="h-5 w-5" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none">
                        <path stroke-linecap="round" stroke-linejoin="round" d="M4 6h16M4 12h16M4 18h16" />
                    </svg>
                    <span class="text-xs font-semibold">{{ __('Menu') }}</span>
                </button>
            </div>
        </header>

        {{-- MOBILE MENU --}}
        <div id="mobileMenu" class="mobile-menu hidden lg:hidden p-4">
            {{-- Mobile Navigation --}}
            <nav class="flex flex-col gap-2 border-b border-border pb-4 mb-4" aria-label="{{ __('Mobile navigation') }}">
                @foreach ($navLinks as $link)
                    <a 
                        href="{{ $link['route'] }}"
                        @class(['nav-link w-full text-left justify-between flex', 'nav-link-active' => $link['active']])
                        @if($link['active']) aria-current="page" @endif
                    >
                        <span>{{ $link['label'] }}</span>
                        @if($link['active'])
                            <span class="text-xs text-accent font-medium">{{ __('Active') }}</span>
                        @endif
                    </a>
                @endforeach
            </nav>

            {{-- Mobile Search --}}
            <form action="{{ route('apps.search') }}" method="GET" class="mb-4">
                <label class="sr-only">{{ __('Search apps') }}</label>
                <div class="relative">
                    <input 
                        type="text"
                        name="q"
                        value="{{ request('q') }}"
                        class="input-field pl-5 pr-10"
                        placeholder="{{ __('Search apps...') }}"
                    >
                    <span class="absolute right-3 top-1/2 -translate-y-1/2 text-muted">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="m21 21-5.2-5.2m0 0a7.5 7.5 0 1 0-10.6-10.6 7.5 7.5 0 0 0 10.6 10.6z"/>
                        </svg>
                    </span>
                </div>
            </form>

            {{-- Mobile Actions --}}
            <div class="mt-4 flex items-center gap-3">
                <div class="flex-1">
                    @include('components.language-switcher', [
                        'wrapperClass' => 'inline-flex items-center gap-2',
                        'selectClass' => 'language-select',
                    ])
                </div>
                <button id="mobileDarkToggle" type="button" class="pill-button flex-shrink-0 min-w-[100px] justify-center">
                    {{ $isDarkMode ? __('Light') : __('Dark') }}
                </button>
            </div>
        </div>

        {{-- MAIN CONTENT --}}
        <main class="site-main">
            <div class="page-wrapper">
                @yield('content')
            </div>
        </main>

        {{-- FOOTER --}}
        <footer class="footer-shell">
            <div class="footer-inner">
                {{-- About --}}
                <div class="space-y-3">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted">{{ __('About') }}</p>
                    <h3 class="footer-heading">{{ __('Android downloads reimagined') }}</h3>
                    <p class="footer-muted text-sm">
                        {{ __('Fresh builds, curated selections, and multilingual experiences in a single lightning-fast catalog.') }}
                    </p>
                </div>

                {{-- Navigation --}}
                <div class="footer-links">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted">{{ __('Navigation') }}</p>
                    <div class="mt-2 space-y-2">
                        <a href="{{ route('apps.latest') }}">{{ __('Latest Apps') }}</a>
                        <a href="{{ route('apps.popular') }}">{{ __('Top Downloads') }}</a>
                        <a href="{{ route('apps.categories') }}">{{ __('Browse Categories') }}</a>
                        <a href="{{ route('contact') }}">{{ __('Contact') }}</a>
                    </div>
                </div>

                {{-- Policies --}}
                <div class="footer-links">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted">{{ __('Policies') }}</p>
                    <div class="mt-2 space-y-2">
                        <a href="{{ route('about') }}">{{ __('About Us') }}</a>
                        <a href="{{ route('terms') }}">{{ __('Terms of Service') }}</a>
                        <a href="{{ route('privacy') }}">{{ __('Privacy Policy') }}</a>
                    </div>
                </div>

                {{-- Support --}}
                <div class="space-y-3">
                    <p class="footer-title uppercase tracking-widest text-xs text-muted">{{ __('Support') }}</p>
                    <p class="footer-muted text-sm">
                        {{ __('Need help importing or distributing an APK? Drop us a line anytime at support@apks.center') }}
                    </p>
                    <a href="mailto:support@apks.center" class="footer-cta mt-4">
                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                            <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.012 1.874l-7.5 4.688a2.25 2.25 0 0 1-2.25 0l-7.5-4.688A2.25 2.25 0 0 1 2.25 6.993V6.75" />
                        </svg>
                        <span class="text-xs font-semibold">{{ __('Email support') }}</span>
                    </a>
                </div>
            </div>

            {{-- Footer Bottom --}}
            <div class="footer-bottom">
                <p class="text-xs">
                    {{ __('© :year :app_name. All rights reserved.', ['year' => now()->year, 'app_name' => $appName]) }}
                </p>
                <p class="text-xs">
                    {{ __('Curated in multiple locales for multilingual users worldwide.') }}
                </p>
            </div>
        </footer>
    </div>

    @stack('scripts')
</body>
</html>