@extends('layouts.app')

@section('title', $title ?? config('app.name'))

@section('meta_description', __('Android app repository'))

@section('content')
    @php
        // View receives computed values from the controller: 
        // $totalDownloads, $featuredCount, $categoriesCount, $hasImportSources, and arrays/collections.
        // Ensure a safe default if the cache was created before controller added these keys.
        $hasImportSources = isset($hasImportSources) ? $hasImportSources : (!empty($importSources ?? []));
    @endphp

    {{-- HERO SECTION --}}
    <section class="hero-section">
        <div class="hero-grid">
            {{-- Left: main pitch --}}
            <div class="space-y-6">
                <div>
                    <h1 class="text-4xl font-bold text-accent mb-4">
                        {{ __('Welcome to :app', ['app' => config('app.name')]) }}
                    </h1>
                    <p class="text-lg text-muted">
                        {{ __('Discover and download the latest Android apps and games') }}
                    </p>
                </div>

                <div class="stats-grid">
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent">{{ number_format($totalDownloads ?? 0) }}</strong>
                        <span class="text-sm text-muted">{{ __('Total Downloads') }}</span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent">{{ number_format($featuredCount ?? 0) }}</strong>
                        <span class="text-sm text-muted">{{ __('Featured Apps') }}</span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-3xl font-bold text-accent">{{ number_format($categoriesCount ?? 0) }}</strong>
                        <span class="text-sm text-muted">{{ __('Categories') }}</span>
                    </div>
                </div>
            </div>

            {{-- Right: live feed --}}
            <div class="connected-card">
                <div class="flex items-start justify-between gap-2">
                    <div>
                        <p class="section-heading">{{ __('Live feed') }}</p>
                        <h3 class="section-title text-lg">
                            {{ __('Fresh arrivals') }}
                        </h3>
                    </div>
                    <span class="badge">
                        {{ __('Updated :time', ['time' => now()->diffForHumans(null, true)]) }}
                    </span>
                </div>

                <ul class="mt-4 space-y-3">
                    @forelse ($latestApps->take(4) as $app)
                        <li class="flex items-center gap-3 rounded-2xl border border-[#dfe6f0] p-3">
                            <img
                                src="{{ $app->icon_url }}"
                                alt="{{ $app->getTranslatedName() }}"
                                class="h-12 w-12 rounded-2xl object-cover shadow-sm"
                                loading="lazy"
                            >
                            <div class="min-w-0 flex-1">
                                <a
                                    href="{{ route('apps.show', $app->slug) }}"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    {{ $app->getTranslatedName() }}
                                </a>
                                <p class="text-muted text-xs truncate">
                                    {{ $app->category?->getTranslatedName() ?? __('Uncategorized') }}
                                </p>
                            </div>
                            <div class="text-right text-xs text-muted">
                                <div>{{ $app->latest_version }}</div>
                                <div>{{ $app->updated_at?->diffForHumans() }}</div>
                            </div>
                        </li>
                    @empty
                        <li class="text-sm text-muted">
                            {{ __('No apps found in the live feed yet.') }}
                        </li>
                    @endforelse
                </ul>

                <div class="mt-4">
                    <p class="section-heading">
                        {{ __('Connected feeds') }}
                    </p>

                    @if ($hasImportSources)
                        <div class="mt-3 flex flex-wrap gap-2">
                            @foreach ($importSources as $sourceName)
                                <span class="badge">
                                    {{ $sourceName }}
                                </span>
                            @endforeach
                        </div>
                    @else
                        <p class="mt-2 footer-muted text-sm">
                            {{ __('Plug in your first import source to initialize live syncing.') }}
                        </p>
                    @endif
                </div>
            </div>
        </div>
    </section>

    {{-- MULTI-SOURCE / PIPELINE --}}
    <section class="page-section">
        <div class="text-center mb-8">
            <h2 class="text-3xl font-bold text-accent mb-3">
                {{ __('Multi-Source Pipeline') }}
            </h2>
            <p class="text-muted text-lg">
                {{ __('Automated app importing from multiple trusted sources') }}
            </p>
        </div>

        <div class="section-grid">
            <div class="feature-card">
                <div class="text-4xl mb-4">🔄</div>
                <h3 class="text-xl font-semibold text-accent mb-2">{{ __('Auto Sync') }}</h3>
                <p class="text-muted text-sm">
                    {{ __('Automatically import and update apps from connected sources') }}
                </p>
            </div>

            <div class="feature-card">
                <div class="text-4xl mb-4">⚡</div>
                <h3 class="text-xl font-semibold text-accent mb-2">{{ __('Fast Updates') }}</h3>
                <p class="text-muted text-sm">
                    {{ __('Get the latest app versions as soon as they are available') }}
                </p>
            </div>

            <div class="feature-card">
                <div class="text-4xl mb-4">🔒</div>
                <h3 class="text-xl font-semibold text-accent mb-2">{{ __('Secure') }}</h3>
                <p class="text-muted text-sm">
                    {{ __('All apps are scanned and verified before publishing') }}
                </p>
            </div>
        </div>
    </section>

    {{-- FEATURED APPS --}}
    <section class="page-section">
        <div class="flex flex-col gap-3 mb-6">
            <h2 class="text-3xl font-bold text-accent">
                {{ __('Featured Apps') }}
            </h2>
            <p class="text-muted text-lg">
                {{ __('Hand-picked quality applications for you') }}
            </p>
        </div>

        <div class="section-footer mb-6">
            <a href="{{ route('apps.latest') }}" class="btn-secondary">
                {{ __('View All Apps') }} →
            </a>
        </div>

        <div class="section-grid mt-4">
            @forelse ($featuredApps as $app)
                <article class="app-card">
                    <div class="flex items-center gap-4">
                        <img
                            src="{{ $app->icon_url }}"
                            alt="{{ $app->getTranslatedName() }}"
                            class="h-16 w-16 rounded-2xl object-cover shadow-sm"
                            loading="lazy"
                        >
                        <div class="min-w-0 flex-1">
                            <a
                                href="{{ route('apps.show', $app->slug) }}"
                                class="text-lg font-semibold text-accent line-clamp-1"
                            >
                                {{ $app->getTranslatedName() }}
                            </a>
                            <p class="text-muted text-sm line-clamp-1">
                                {{ $app->developer }}
                            </p>
                        </div>
                    </div>

                    <p class="mt-3 text-muted text-sm line-clamp-3">
                        {{ Str::limit($app->getTranslatedDescription(), 160) }}
                    </p>

                    <div class="app-actions mt-3">
                        @if (!is_null($app->rating))
                            <span class="badge">
                                ★ {{ number_format($app->rating, 1) }}
                            </span>
                        @endif
                        <span class="text-muted text-sm">
                            {{ $app->formatted_downloads }} {{ __('Downloads') }}
                        </span>
                    </div>

                    <div class="app-actions mt-3">
                        <a href="{{ route('apps.show', $app->slug) }}" class="btn-secondary text-center text-sm">
                            {{ __('Details') }}
                        </a>
                        <a href="{{ route('download.show', $app->slug) }}" class="btn-primary text-center text-sm">
                            {{ __('Download') }}
                        </a>
                    </div>
                </article>
            @empty
                <p class="text-muted col-span-full text-center py-8">
                    {{ __('No featured apps yet.') }}
                </p>
            @endforelse
        </div>
    </section>

    {{-- TOP CATEGORIES --}}
    <section class="page-section">
        <div class="glass-panel">
            <div class="flex flex-col gap-1 mb-6">
                <h2 class="text-3xl font-bold text-accent">
                    {{ __('Top Categories') }}
                </h2>
                <p class="text-muted text-lg">
                    {{ __('Browse apps by category') }}
                </p>
            </div>

            <div class="section-grid mt-6">
                @forelse ($topCategories as $category)
                    <a
                        href="{{ route('apps.category', $category->slug) }}"
                        class="feature-card"
                    >
                        <div>
                            <p class="text-lg font-semibold text-accent line-clamp-1">
                                {{ $category->getTranslatedName() }}
                            </p>
                            <p class="text-muted text-sm">
                                {{ number_format($category->apps_count) }} {{ __('apps available') }}
                            </p>
                        </div>
                        <span class="text-muted text-3xl">
                            @include('components.category-icon', [
                                'slug'  => $category->slug,
                                'color' => '',
                            ])
                        </span>
                    </a>
                @empty
                    <p class="text-sm text-muted col-span-full text-center py-8">
                        {{ __('No categories available yet.') }}
                    </p>
                @endforelse
            </div>
        </div>
    </section>

    {{-- LATEST & MOST DOWNLOADED --}}
    <section class="page-section">
        <div class="grid gap-6 lg:grid-cols-2">
            {{-- Latest updates --}}
            <div class="feature-card">
                <div class="flex items-center justify-between gap-2 mb-4">
                    <div>
                        <h3 class="text-xl font-bold text-accent">
                            {{ __('Latest Updates') }}
                        </h3>
                        <p class="text-muted text-sm">
                            {{ __('Recently updated apps') }}
                        </p>
                    </div>
                </div>

                <div class="mt-4 space-y-3">
                    @forelse ($latestApps->take(5) as $app)
                        <div class="flex items-center justify-between gap-3">
                            <div class="min-w-0">
                                <a
                                    href="{{ route('apps.show', $app->slug) }}"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    {{ $app->getTranslatedName() }}
                                </a>
                                <p class="text-muted text-xs line-clamp-2">
                                    {{ Str::limit($app->getTranslatedDescription(), 90) }}
                                </p>
                            </div>
                            <span class="shrink-0 text-xs text-muted">
                                {{ $app->updated_at?->diffForHumans() }}
                            </span>
                        </div>
                    @empty
                        <p class="text-sm text-muted">
                            {{ __('No recent updates yet.') }}
                        </p>
                    @endforelse
                </div>
            </div>

            {{-- Most downloaded --}}
            <div class="connected-card">
                <div class="flex items-center justify-between gap-2 mb-4">
                    <div>
                        <h3 class="text-xl font-bold text-accent">
                            {{ __('Most Downloaded') }}
                        </h3>
                        <p class="text-muted text-sm">
                            {{ __('Popular apps this month') }}
                        </p>
                    </div>
                </div>

                <ul class="mt-4 space-y-3">
                    @forelse ($mostDownloadedApps->take(5) as $app)
                        <li class="flex items-center justify-between gap-3">
                            <div class="min-w-0">
                                <a
                                    href="{{ route('apps.show', $app->slug) }}"
                                    class="font-semibold text-accent line-clamp-1"
                                >
                                    {{ $app->getTranslatedName() }}
                                </a>
                                <p class="text-muted text-xs truncate">
                                    {{ $app->category?->getTranslatedName() ?? __('Uncategorized') }}
                                </p>
                            </div>
                            <span class="shrink-0 text-sm font-semibold text-muted">
                                {{ $app->formatted_downloads }}
                            </span>
                        </li>
                    @empty
                        <li class="text-sm text-muted">
                            {{ __('No popular apps to show yet.') }}
                        </li>
                    @endforelse
                </ul>
            </div>
        </div>
    </section>

    {{-- SOURCES / AUTOMATION --}}
    <section class="page-section">
        <div class="grid gap-6 lg:grid-cols-2">
            <div class="connected-card">
                <h3 class="text-xl font-bold text-accent mb-2">
                    {{ __('Import Sources') }}
                </h3>
                <p class="text-muted text-sm mb-4">
                    {{ __('Connected app sources and feeds') }}
                </p>

                <div class="stats-grid mt-4">
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent">{{ count($importSources ?? []) }}</strong>
                        <span class="text-sm text-muted">{{ __('Active Sources') }}</span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent">{{ number_format($totalDownloads ?? 0) }}</strong>
                        <span class="text-sm text-muted">{{ __('Total Downloads') }}</span>
                    </div>
                </div>
            </div>

            <div class="connected-card">
                <h3 class="text-xl font-bold text-accent mb-2">
                    {{ __('Automation') }}
                </h3>
                <p class="text-muted text-sm mb-4">
                    {{ __('Automated processes and updates') }}
                </p>

                <div class="stats-grid mt-4">
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent">24/7</strong>
                        <span class="text-sm text-muted">{{ __('Monitoring') }}</span>
                    </div>
                    <div class="stat-card">
                        <strong class="text-2xl font-bold text-accent">{{ __('Auto') }}</strong>
                        <span class="text-sm text-muted">{{ __('Updates') }}</span>
                    </div>
                </div>
            </div>
        </div>
    </section>
@endsection