@extends('layouts.app')

@section('content')
<div class="min-h-screen bg-gradient-to-br from-gray-50 to-gray-100 dark:from-gray-900 dark:to-gray-800 flex items-center justify-center">
    <div class="max-w-md w-full mx-4 text-center">
        <div class="bg-white dark:bg-gray-800 rounded-2xl shadow-2xl p-8">
            <div class="mb-6">
                <div class="inline-flex items-center justify-center w-20 h-20 bg-red-100 dark:bg-red-900/20 rounded-full mb-4">
                    <svg class="w-10 h-10 text-red-600 dark:text-red-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4m0 4h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0z"/>
                    </svg>
                </div>
                <h1 class="text-6xl font-bold text-gray-900 dark:text-white mb-2">404</h1>
                <h2 class="text-2xl font-semibold text-gray-900 dark:text-white mb-4">
                    {{ __('Page Not Found') }}
                </h2>
                <p class="text-gray-600 dark:text-gray-400 mb-8">
                    {{ __('The page you are looking for doesn\'t exist or has been moved.') }}
                </p>
            </div>

            <div class="space-y-4">
                <a href="{{ route('home') }}"
                   class="btn-primary w-full">
                    {{ __('Go Back Home') }}
                </a>
                <a href="{{ route('apps.latest') }}"
                   class="btn-secondary w-full">
                    {{ __('Browse Latest Apps') }}
                </a>
            </div>

            <div class="mt-8 text-center">
                <p class="text-sm text-gray-600 dark:text-gray-400">
                    {{ __('Or try searching for what you need:') }}
                </p>
                <form action="{{ route('apps.search') }}" method="GET" class="mt-2">
                    <input type="text"
                           name="q"
                           placeholder="{{ __('Search apps...') }}"
                           class="input-field">
                </form>
            </div>
        </div>

        <div class="mt-6">
            <p class="text-gray-600 dark:text-gray-400 text-sm">
                {{ __('Error Code') }}: 404
            </p>
        </div>
    </div>
</div>
@endsection
