@extends('layouts.app')

@section('content')
<!-- Main container with proper RTL/LTR handling -->
<div class="min-h-screen bg-gradient-to-br from-blue-50 to-indigo-100 dark:from-gray-900 dark:to-gray-800 flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">
    <div class="max-w-md w-full mx-auto">
        <!-- Download Card -->
        <div class="bg-white dark:bg-gray-800 rounded-3xl shadow-2xl overflow-hidden transform transition-all duration-300 hover:scale-[1.01]">

            <!-- App Header -->
            <div class="bg-gradient-to-r from-blue-600 to-purple-600 p-6 text-white text-right">
                <div class="flex items-center space-x-4 rtl:space-x-reverse">
                    <img src="{{ $app->icon_url }}"
                            alt="{{ $app->getTranslatedName() }} icon"
                            class="w-16 h-16 rounded-xl shadow-lg flex-shrink-0">
                    <div>
                        <h1 class="text-2xl font-bold">{{ $app->getTranslatedName() }}</h1>
                        <p class="text-blue-100 mt-1">{{ $app->developer }}</p>
                    </div>
                </div>
            </div>

            <!-- Countdown Section -->
            <div class="p-8 sm:p-10 text-center">

                <!-- Loading Animation -->
                <div class="mb-8">
                    <div class="inline-flex items-center justify-center w-20 h-20 bg-blue-100 dark:bg-blue-900/20 rounded-full animate-pulse-slow">
                        <svg class="w-10 h-10 text-blue-600 dark:text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-3 3m3-3v12"/>
                        </svg>
                    </div>
                </div>

                <!-- Countdown Timer Display -->
                <div class="mb-8">
                    <p class="text-lg text-gray-600 dark:text-gray-400 mb-2 font-medium">
                        {{ __('Your download will start automatically in') }}
                    </p>
                    <div class="text-7xl font-extrabold text-blue-600 dark:text-blue-400 transition-colors duration-500" id="countdown">
                        {{ $waitTime }}
                    </div>
                    <p class="text-lg text-gray-600 dark:text-gray-400 mt-2">
                        {{ __('seconds') }}
                    </p>
                </div>

                <!-- Progress Bar -->
                <div class="w-full bg-gray-200 dark:bg-gray-700 rounded-full h-3 mb-8">
                    <!-- Note: Progress bar must have LTR direction regardless of page RTL, to grow left-to-right -->
                    <div id="progress" class="bg-gradient-to-r from-blue-600 to-purple-600 h-3 rounded-full transition-all duration-1000 ease-linear progress-bar ltr-direction"></div>
                </div>

                <!-- App Info Summary -->
                <div class="bg-gray-50 dark:bg-gray-700/50 rounded-xl p-4 mb-6 text-right border border-gray-100 dark:border-gray-700">
                    <div class="grid grid-cols-2 gap-4 text-sm font-medium">
                        <div class="text-right">
                            <p class="text-gray-500 dark:text-gray-400">{{ __('Version') }}</p>
                            <p class="font-bold text-gray-900 dark:text-white">{{ $app->latest_version }}</p>
                        </div>
                        <div class="text-right">
                            <p class="text-gray-500 dark:text-gray-400">{{ __('File Size') }}</p>
                            <p class="font-bold text-gray-900 dark:text-white">{{ $app->formatted_size }}</p>
                        </div>
                    </div>
                </div>

                <!-- Manual Download Link (after countdown) -->
                <div id="manual-download" class="hidden pt-4">
                    <p class="text-gray-700 dark:text-gray-300 mb-4 font-semibold">
                        {{ __('If your download doesn\'t start automatically') }}:
                    </p>
                    <a href="{{ route('download.process', $app->slug) }}"
                        class="inline-flex items-center justify-center px-8 py-3 bg-gradient-to-r from-teal-500 to-green-600 text-white font-extrabold rounded-xl shadow-xl hover:shadow-green-500/50 transform hover:scale-105 transition-all duration-200">
                        <svg class="w-5 h-5 ml-3 rtl:mr-3 rtl:ml-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                        </svg>
                        {{ __('Click to Start Download') }}
                    </a>
                </div>

                <!-- Cancel Button -->
                <div class="mt-6">
                    <a href="{{ route('apps.show', $app->slug) }}"
                        class="text-gray-500 dark:text-gray-400 hover:text-red-500 text-sm transition-colors font-medium">
                        {{ __('Cancel Download and Go Back') }}
                    </a>
                </div>
            </div>
        </div>

        <!-- Safety Notice (Kept outside the main card for separation) -->
        <div class="mt-6 bg-green-50 dark:bg-green-900/20 border border-green-200 dark:border-green-800 rounded-xl p-4 text-right shadow-md">
            <div class="flex items-start space-x-3 rtl:space-x-reverse">
                <svg class="w-6 h-6 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                </svg>
                <div class="text-right">
                    <h3 class="text-base font-semibold text-green-800 dark:text-green-200">
                        {{ __('Security Verified') }}
                    </h3>
                    <p class="text-sm text-green-700 dark:text-green-300 mt-1">
                        {{ __('This file has passed all our malware and virus checks.') }}
                    </p>
                </div>
            </div>
        </div>
    </div>
</div>

<script>
    // Initialize countdown
    let counter = {{ $waitTime }};
    const countdownElement = document.getElementById('countdown');
    const progressElement = document.getElementById('progress');
    const manualDownloadElement = document.getElementById('manual-download');
    const totalTime = {{ $waitTime }};
    const redirectUrl = "{{ route('download.process', $app->slug) }}";

    // Function to calculate and update progress bar width
    function updateProgress(currentCounter) {
        // Progress increases from 0% (start) to 100% (end of timer)
        const progress = ((totalTime - currentCounter) / totalTime) * 100;
        if (progressElement) {
            progressElement.style.width = Math.min(100, Math.max(0, progress)) + '%';
        }
    }

    // Countdown function
    function updateCountdown() {
        if (counter >= 0) {
            if (countdownElement) {
                countdownElement.textContent = counter;
            }
            updateProgress(counter);
            counter--;

        } else {
            clearInterval(countdownInterval);

            // Final progress update
            updateProgress(0);

            // Update countdown message
            if (countdownElement) {
                countdownElement.textContent = '✓';
                countdownElement.classList.remove('text-blue-600', 'dark:text-blue-400');
                countdownElement.classList.add('text-green-600', 'dark:text-green-400');
            }

            // Show manual download link
            if (manualDownloadElement) {
                manualDownloadElement.classList.remove('hidden');
            }

            // Redirect to actual download after a short delay (2 seconds)
            setTimeout(() => {
                window.location.href = redirectUrl;
            }, 2000);
        }
    }

    // Start countdown immediately
    const countdownInterval = setInterval(updateCountdown, 1000);
    updateCountdown(); // Run once instantly to set initial progress and counter

    // Prevent page navigation during countdown
    window.addEventListener('beforeunload', function (e) {
        if (counter > 0) {
            e.preventDefault();
            e.returnValue = '{{ __('Your download is about to start. Are you sure you want to leave?') }}';
        }
    });
</script>
@endsection
