@extends('layouts.app')

@section('content')
<!-- Container for Download Details - Using Tailwind classes for modern look -->
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 flex items-center justify-center py-12 px-4 sm:px-6 lg:px-8">

    <!-- Card Container -->
    <div class="max-w-xl w-full space-y-8 bg-white dark:bg-gray-800 p-8 sm:p-12 rounded-3xl shadow-2xl transform hover:shadow-3xl transition-all duration-300">

        <!-- App Header -->
        <div class="flex items-center space-x-4 rtl:space-x-reverse border-b border-gray-100 dark:border-gray-700 pb-6">
            <!-- App Icon (Rounded-xl = rounded-corners) -->
            <img src="{{ $app->icon_url }}"
                alt="{{ $app->getTranslatedName() }} icon"
                class="w-20 h-20 rounded-2xl shadow-lg object-cover flex-shrink-0">
            <div>
                <h1 class="text-3xl font-extrabold text-gray-900 dark:text-white">
                    {{ $app->getTranslatedName() }}
                </h1>
                <p class="text-md text-gray-500 dark:text-gray-400 mt-1">
                    {{ __('Developer') }}: {{ $app->developer }}
                </p>
            </div>
        </div>

        <!-- Download Instructions and Button -->
        <div class="text-center">

            <!-- Icon for Visual Appeal -->
            <svg class="mx-auto h-24 w-24 text-teal-500 dark:text-teal-400 mb-6 animate-bounce" fill="none" stroke="currentColor" viewBox="0 0 24 24" xmlns="http://www.w3.org/2000/svg">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="1.5" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
            </svg>

            <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-3">
                {{ __('Download is Ready!') }}
            </h2>
            <p class="text-gray-600 dark:text-gray-400 mb-8 max-w-sm mx-auto">
                {{ __('Please click the button below. Your download will start automatically.') }}
            </p>

            <!-- Main Download Button -->
            <a href="{{ $finalDownloadUrl ?? $app->download_url }}"
                id="download-button"
                class="download-button inline-flex items-center justify-center w-full px-8 py-4 bg-gradient-to-r from-teal-500 to-green-600 text-white font-extrabold text-xl rounded-2xl shadow-2xl hover:shadow-green-500/50 transform hover:scale-[1.02] transition-all duration-300 focus:outline-none focus:ring-4 focus:ring-green-500/50"
                onclick="startDownloadTimer(this)">
                <svg class="w-6 h-6 mr-3 rtl:ml-3 rtl:mr-0" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                </svg>
                <span id="button-text">{{ __('Start Download') }} ({{ $app->formatted_size }})</span>
            </a>

            <p class="text-sm text-gray-500 dark:text-gray-400 mt-4">
                {{ __('File Name') }}: {{ $app->package_name }}.apk
            </p>
        </div>

        <!-- Safety and Information Bar -->
        <div class="space-y-4 pt-6 border-t border-gray-100 dark:border-gray-700">

            <!-- Safety Status -->
            <div class="flex items-start space-x-3 rtl:space-x-reverse bg-green-50 dark:bg-green-900/20 p-4 rounded-xl border border-green-200 dark:border-green-800">
                <svg class="w-6 h-6 text-green-600 dark:text-green-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m5.618-4.016A11.955 11.955 0 0112 2.944a11.955 11.955 0 01-8.618 3.04A12.02 12.02 0 003 9c0 5.591 3.824 10.29 9 11.622 5.176-1.332 9-6.03 9-11.622 0-1.042-.133-2.052-.382-3.016z"/>
                </svg>
                <div class="text-right">
                    <h3 class="text-base font-semibold text-green-800 dark:text-green-200">
                        {{ __('Verified File') }}
                    </h3>
                    <p class="text-sm text-green-700 dark:text-green-300">
                        {{ __('This file has passed security checks and is free of malware.') }}
                    </p>
                </div>
            </div>

            <!-- Version Info (Simplified to one line) -->
            <div class="flex items-start space-x-3 rtl:space-x-reverse bg-blue-50 dark:bg-blue-900/20 p-4 rounded-xl border border-blue-200 dark:border-blue-800">
                <svg class="w-6 h-6 text-blue-600 dark:text-blue-400 flex-shrink-0 mt-0.5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 16a4 4 0 01-.88-7.903A5 5 0 1115.9 6L16 6a5 5 0 011 9.9M15 13l-3-3m0 0l-4 4m4 0V4"/>
                </svg>
                <div class="text-right">
                    <h3 class="text-base font-semibold text-blue-800 dark:text-blue-200">
                        {{ __('File Information') }}
                    </h3>
                    <p class="text-sm text-blue-700 dark:text-blue-300">
                        {{ __('Version') }}: **{{ $app->latest_version }}** | {{ __('Size') }}: **{{ $app->formatted_size }}** | {{ __('Last Updated') }}: **{{ $app->formatted_last_updated }}**
                    </p>
                </div>
            </div>
        </div>

        <!-- Optional: Small disclaimer -->
        <p class="text-xs text-gray-400 dark:text-gray-600 text-center pt-4">
            {{ __('If the download does not start automatically, please refresh the page and click the button again.') }}
        </p>

    </div>
</div>

<script>
    /**
     * Function to temporarily change the button text to give visual feedback
     * that the download is initiating.
     * @param {HTMLElement} buttonElement - The button element that was clicked.
     */
    function startDownloadTimer(buttonElement) {
        // Find the button's text span
        const textSpan = buttonElement.querySelector('#button-text');

        // Disable the onclick event to prevent the function from running multiple times
        buttonElement.onclick = function() { return true; };

        // Define the countdown duration (e.g., 3 seconds)
        let countdown = 3;

        // Change button styling to "processing"
        buttonElement.classList.remove('from-teal-500', 'to-green-600', 'hover:scale-[1.02]', 'shadow-2xl');
        buttonElement.classList.add('from-gray-400', 'to-gray-500', 'shadow-none', 'cursor-not-allowed');

        function updateTimer() {
            if (countdown > 0) {
                textSpan.textContent = `{{ __('Initiating download') }} (${countdown})...`;
                countdown--;
                setTimeout(updateTimer, 1000);
            } else {
                // Timer finished: Change button to success/complete state
                textSpan.textContent = `{{ __('Download Starting!') }}`;

                buttonElement.classList.remove('from-gray-400', 'to-gray-500', 'cursor-not-allowed');
                buttonElement.classList.add('from-indigo-600', 'to-indigo-800');

                // Since this is an <a> tag, the download already started when the user clicked.
                // We just stop the visual timer here.
            }
        }

        // Start the timer visually
        updateTimer();

        // Return true to allow the <a> tag to follow its href (which starts the download)
        return true;
    }
</script>
@endsection
