@extends('layouts.app')

@section('title', __('Contact'))

@section('content')
    <section class="bg-gradient-to-r from-indigo-500 to-purple-600 py-16 text-white">
        <div class="mx-auto max-w-4xl px-6 text-center">
            <p class="text-sm font-semibold uppercase tracking-wide text-white/80">{{ __('We are here to help') }}</p>
            <h1 class="mt-2 text-4xl font-bold">{{ __('Contact Us') }}</h1>
            <p class="mt-3 text-white/80">{{ __('Get in touch with our support team for partnerships, submissions, or general help.') }}</p>
        </div>
    </section>

    <section class="mx-auto max-w-5xl px-6 py-14">
        <div class="grid gap-6 md:grid-cols-2">
            <div class="rounded-3xl border border-slate-100 bg-white p-8 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <h2 class="text-2xl font-bold text-slate-900 dark:text-white">{{ __('Support Channels') }}</h2>
                <p class="mt-2 text-slate-500 dark:text-slate-400">{{ __('We respond within 24 hours, Monday to Friday.') }}</p>
                <div class="mt-6 space-y-4 text-sm text-slate-600 dark:text-slate-300">
                    <div class="flex gap-4 rounded-2xl border border-slate-100 p-4 dark:border-slate-800">
                        <div class="rounded-2xl bg-indigo-50 p-3 text-indigo-600 dark:bg-indigo-900/40">
                            <svg class="h-5 w-5" fill="none" stroke="currentColor" stroke-width="1.5" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M21.75 6.75v10.5a2.25 2.25 0 0 1-2.25 2.25h-15a2.25 2.25 0 0 1-2.25-2.25V6.75m19.5 0A2.25 2.25 0 0 0 19.5 4.5h-15a2.25 2.25 0 0 0-2.25 2.25m19.5 0v.243a2.25 2.25 0 0 1-1.012 1.874l-7.5 4.688a2.25 2.25 0 0 1-2.25 0l-7.5-4.688A2.25 2.25 0 0 1 2.25 6.993V6.75" />
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs uppercase tracking-wide text-slate-500 dark:text-slate-400">{{ __('Email') }}</p>
                            <p class="font-semibold text-slate-900 dark:text-white">support@apks.center</p>
                        </div>
                    </div>
                    <div class="flex gap-4 rounded-2xl border border-slate-100 p-4 dark:border-slate-800">
                        <div class="rounded-2xl bg-indigo-50 p-3 text-indigo-600 dark:bg-indigo-900/40">
                            <svg class="h-5 w-5" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" fill="none">
                                <path stroke-linecap="round" stroke-linejoin="round" d="M2.25 6.75c0 8.284 6.716 15 15 15h2.25a2.25 2.25 0 0 0 2.25-2.25v-1.372c0-.516-.351-.966-.852-1.091l-4.423-1.106a1.125 1.125 0 0 0-1.173.417l-.97 1.293a1.125 1.125 0 0 1-1.21.38 12.035 12.035 0 0 1-7.143-7.143 1.125 1.125 0 0 1 .38-1.21l1.293-.97c.363-.272.527-.739.417-1.173L6.963 3.102a1.125 1.125 0 0 0-1.091-.852H4.5A2.25 2.25 0 0 0 2.25 4.5v2.25z" />
                            </svg>
                        </div>
                        <div>
                            <p class="text-xs uppercase tracking-wide text-slate-500 dark:text-slate-400">{{ __('Phone') }}</p>
                            <p class="font-semibold text-slate-900 dark:text-white">+971 50 123 4567</p>
                        </div>
                    </div>
                </div>
            </div>

            <div class="rounded-3xl border border-slate-100 bg-white p-8 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <h2 class="text-2xl font-bold text-slate-900 dark:text-white">{{ __('Send us a message') }}</h2>
                <form class="mt-6 space-y-4">
                    <div>
                        <label class="text-sm font-medium text-slate-600 dark:text-slate-300">{{ __('Name') }}</label>
                        <input type="text" class="mt-1 w-full rounded-2xl border border-slate-200 px-4 py-2.5 text-slate-900 focus:border-indigo-400 focus:outline-none dark:border-slate-700 dark:bg-slate-800 dark:text-slate-100">
                    </div>
                    <div>
                        <label class="text-sm font-medium text-slate-600 dark:text-slate-300">{{ __('Email') }}</label>
                        <input type="email" class="mt-1 w-full rounded-2xl border border-slate-200 px-4 py-2.5 text-slate-900 focus:border-indigo-400 focus:outline-none dark:border-slate-700 dark:bg-slate-800 dark:text-slate-100">
                    </div>
                    <div>
                        <label class="text-sm font-medium text-slate-600 dark:text-slate-300">{{ __('Message') }}</label>
                        <textarea rows="4" class="mt-1 w-full rounded-2xl border border-slate-200 px-4 py-2.5 text-slate-900 focus:border-indigo-400 focus:outline-none dark:border-slate-700 dark:bg-slate-800 dark:text-slate-100"></textarea>
                    </div>
                    <button type="button" class="w-full rounded-2xl bg-indigo-600 py-3 text-sm font-semibold text-white hover:bg-indigo-500">
                        {{ __('Send Message') }}
                    </button>
                </form>
            </div>
        </div>
    </section>
@endsection
