@php
    $supportedLocales = config('app.supported_locales', ['en']);
    $currentLocale = app()->getLocale();
    $returnUrl = request()->fullUrl();
    $wrapperClass = $wrapperClass ?? '';
    $selectClass = $selectClass ?? '';
@endphp

<form action="{{ route('language.switch') }}" method="POST" class="{{ $wrapperClass }}">
    @csrf
    <input type="hidden" name="return_url" value="{{ $returnUrl }}">
    <label class="sr-only">{{ __('Change language') }}</label>
    <select
        name="locale"
        class="{{ $selectClass }} cursor-pointer"
        aria-label="{{ __('Change language') }}"
        onchange="this.form.submit()"
    >
        @foreach ($supportedLocales as $supportedLocale)
            <option value="{{ $supportedLocale }}" @selected($supportedLocale === $currentLocale)>
                {{ strtoupper($supportedLocale) }}
            </option>
        @endforeach
    </select>
</form>
