{{-- resources/views/components/category-icon.blade.php --}}
@props(['slug', 'color' => 'text-blue-600'])

<span role="img" aria-label="{{ $slug }}" class="{{ $color }}">
    @switch($slug)
        @case('games')
            &#x1F3AE; {{-- 🎮 Game Controller --}}
            @break
        @case('productivity')
            &#x1F4BC; {{-- 💼 Briefcase --}}
            @break
        @case('social')
            &#x1F4AC; {{-- 💬 Speech Balloon --}}
            @break
        @case('entertainment')
            &#x1F3AC; {{-- 🎬 Film Projector --}}
            @break
        @case('tools')
            &#x1F527; {{-- 🔧 Wrench --}}
            @break
        @case('communication')
            &#x1F4DE; {{-- 📞 Telephone Receiver --}}
            @break
        @case('photography')
            &#x1F4F7; {{-- 📷 Camera --}}
            @break
        @case('music')
            &#x1F3B5; {{-- 🎶 Musical Notes --}}
            @break
        @case('news')
            &#x1F4F0; {{-- 📰 Newspaper --}}
            @break
        @case('shopping')
            &#x1F6CD; {{-- 🛒 Shopping Cart --}}
            @break
        @default
            &#x1F4F1; {{-- 📱 Mobile Phone --}}
    @endswitch
</span>
