@props(['app'])

{{-- Card Container --}}
<div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg hover:shadow-xl transition duration-300 transform hover:-translate-y-0.5">
    <a href="{{ route('apps.show', $app->slug) }}" class="block">
        {{-- Card Content --}}
        <div class="p-4 md:p-6">
            <div class="flex items-start space-x-4 rtl:space-x-reverse">
                {{-- Icon --}}
                <img src="{{ $app->icon_url }}"
                    alt="{{ $app->name }}"
                    class="w-16 h-16 md:w-20 md:h-20 flex-shrink-0 rounded-2xl shadow-md object-cover">

                {{-- Details --}}
                <div class="flex-1 min-w-0">
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-1 truncate">{{ $app->name }}</h3>

                    {{-- Category and Rating --}}
                    <div class="flex items-center justify-between text-sm mb-2">
                        <span class="text-blue-600 dark:text-blue-400 font-medium">{{ $app->category->name }}</span>
                        <div class="flex items-center space-x-1 rtl:space-x-reverse">
                            {{-- Star SVG (Replaced the Unicode ★) --}}
                            <svg class="w-4 h-4 text-yellow-500 fill-current" viewBox="0 0 24 24"><path d="M12 .587l3.668 7.568 8.332 1.151-6.064 5.828 1.48 8.281L12 18.232l-7.416 3.983 1.48-8.281L.001 9.306l8.332-1.151L12 .587z"/></svg>
                            <span class="text-gray-600 dark:text-gray-400 font-semibold">{{ number_format($app->rating, 1) }}</span>
                        </div>
                    </div>

                    {{-- Description --}}
                    <p class="text-xs text-gray-500 dark:text-gray-400 line-clamp-2 mb-2">{{ Str::limit($app->description, 100) }}</p>

                    {{-- Version and Update Time --}}
                    <div class="text-xs text-gray-400 dark:text-gray-500 flex justify-between items-center">
                        <span>{{ $app->latest_version }}</span>
                        <span>&bull; {{ $app->updated_at->diffForHumans() }}</span>
                    </div>
                </div>
            </div>
        </div>

        {{-- Footer - Downloads & Download Button --}}
        <div class="px-6 py-3 bg-gray-50 dark:bg-gray-900 border-t border-gray-200 dark:border-gray-700 rounded-b-xl">
            <div class="flex items-center justify-between">
                <span class="text-sm text-gray-600 dark:text-gray-400 font-medium">{{ number_format($app->downloads_count) }} {{ __('downloads') }}</span>
                <span class="text-sm font-bold text-blue-600 dark:text-blue-400 hover:text-blue-700 transition">{{ __('Download') }}</span>
            </div>
        </div>
    </a>
</div>
