"use client";

import { useRef } from "react";

type Props = {
  heading: string;
  sub?: string;
  ctaHref?: string;
};

export default function Hero({ heading, sub, ctaHref = "#" }: Props) {
  const focusRef = useRef<HTMLAnchorElement | null>(null);

  return (
    <section className="hero-section page-section">
      <div className="hero-grid">
        <header>
          <p className="badge">New</p>
          <h1 className="hero-heading">{heading}</h1>
          {sub && <p className="hero-subhead text-muted">{sub}</p>}

          <div className="hero-actions">
            {/* Tailwind v4: bg-linear-* + arbitrary values */}
            <a
              ref={focusRef}
              href={ctaHref}
              className="btn-primary inline-block bg-linear-to-r from-[var(--color-accent)] to-[var(--color-accent-dark)]"
              aria-label="Get started"
            >
              Get started
            </a>
            <a href="#learn" className="btn-secondary inline-block">
              Learn more
            </a>
          </div>
        </header>

        <aside className="stats-grid">
          <div className="stat-card">
            <span>Users</span>
            <strong>12k+</strong>
          </div>
          <div className="stat-card">
            <span>Latency</span>
            <strong>~45ms</strong>
          </div>
          <div className="stat-card">
            <span>Uptime</span>
            <strong>99.98%</strong>
          </div>
        </aside>
      </div>
    </section>
  );
}
