@extends('layouts.app')

@section('title', $title)

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8 md:py-12">
    <div class="mx-auto max-w-6xl px-4">

        <!-- Search Header & Stats -->
        <div class="mb-10 p-6 bg-white dark:bg-gray-800 rounded-xl shadow-lg">

            <h1 class="text-3xl font-extrabold text-gray-900 dark:text-white mb-4">
                {{ __('Search Results') }}
                @if($query)
                    <span class="text-blue-600 dark:text-blue-400">"{{ $query }}"</span>
                @endif
            </h1>

            <!-- Search Form (Redundant but keeps context) -->
            <form action="{{ route('apps.search') }}" method="GET" class="flex gap-2 mb-4">
                <input type="text" name="q" placeholder="{{ __('Search for apps, games, developers...') }}"
                       class="flex-1 px-4 py-2 rounded-lg border border-gray-300 dark:border-gray-600 bg-white dark:bg-gray-900 text-gray-900 dark:text-white focus:outline-none focus:ring-2 focus:ring-blue-500"
                       value="{{ $query }}">
                <button type="submit" class="px-6 py-2 bg-blue-600 text-white rounded-lg font-semibold hover:bg-blue-700 transition">
                    {{ __('Search') }}
                </button>
            </form>

            <!-- Search Stats -->
            <div class="text-sm text-gray-600 dark:text-gray-400">
                @if($query && $apps->total() > 0)
                    {{ __('Found :count apps for ":query"', ['count' => number_format($apps->total()), 'query' => $query]) }}
                @elseif($query)
                    {{ __('No apps found matching your search for ":query"', ['query' => $query]) }}
                @else
                    {{ __('Enter a search term above to find apps') }}
                @endif
            </div>
        </div>

        <!-- Search Results Grid -->
        @if($query && $apps->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-10">
            @foreach($apps as $app)
                {{-- التحسين هنا: استخدام المكون الذي أنشأناه في الخطوة السابقة --}}
                <x-app.list-card :app="$app" />
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="flex justify-center mt-8">
            {{ $apps->links() }}
        </div>

        @elseif($query)
        <!-- No Results Found State -->
        <div class="text-center py-20 bg-white dark:bg-gray-800 rounded-xl shadow-lg">
            <div class="text-7xl mb-4 text-orange-500">😔</div>
            <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">{{ __('No results found') }}</h3>
            <p class="text-gray-600 dark:text-gray-400 max-w-lg mx-auto">{{ __('Try searching for a different term or check your spelling.') }}</p>
        </div>
        @else
        <!-- Initial State (No search term entered yet) -->
        <div class="text-center py-20 bg-white dark:bg-gray-800 rounded-xl shadow-lg">
            <div class="text-7xl mb-4 text-blue-500">🔍</div>
            <h3 class="text-2xl font-bold text-gray-900 dark:text-white mb-2">{{ __('Start searching') }}</h3>
            <p class="text-gray-600 dark:text-gray-400 max-w-lg mx-auto">{{ __('Enter a search term above to quickly find the apps and games you are looking for.') }}</p>
        </div>
        @endif
    </div>
</div>
@endsection
