@extends('layouts.app')

@section('title', $title ?? __('Most Downloaded'))

@section('content')
    <section class="bg-gradient-to-br from-indigo-500 via-purple-500 to-slate-900 py-16 text-white">
        <div class="mx-auto max-w-5xl px-6">
            <p class="text-sm font-semibold uppercase tracking-wide text-white/80">{{ __('Trending') }}</p>
            <h1 class="mt-2 text-4xl font-bold">{{ $title ?? __('Most Downloaded') }}</h1>
            <p class="mt-3 text-white/80">{{ __('Browse the most downloaded apps and games.') }}</p>
            <form action="{{ route('apps.search') }}" method="GET" class="mt-6 flex flex-col gap-3 sm:flex-row">
                <input type="text" name="q" value="{{ request('q') }}" placeholder="{{ __('Search apps...') }}" class="flex-1 rounded-2xl px-5 py-3 text-slate-900 focus:outline-none focus:ring-4 focus:ring-white/30">
                <button class="rounded-2xl bg-white px-6 py-3 text-sm font-semibold text-indigo-600">{{ __('Search') }}</button>
            </form>
        </div>
    </section>

    <section class="mx-auto max-w-6xl px-6 py-14">
        @if ($apps->count())
            <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-3">
                @foreach ($apps as $app)
                    <div class="rounded-2xl border border-slate-100 bg-white/80 p-5 shadow-sm transition hover:-translate-y-1 hover:shadow-lg dark:border-slate-800 dark:bg-slate-900/70">
                        <div class="flex items-start gap-4">
                            <img src="{{ $app->icon_url ?: asset('images/default-icon.png') }}" alt="{{ $app->getTranslatedName() }}" class="h-14 w-14 rounded-2xl object-cover shadow">
                            <div class="flex-1">
                                <a href="{{ route('apps.show', $app->slug) }}" class="text-lg font-semibold text-slate-900 hover:text-indigo-600 dark:text-white">
                                    {{ $app->getTranslatedName() }}
                                </a>
                                <p class="text-sm text-slate-500 dark:text-slate-400">{{ $app->category?->getTranslatedName() }}</p>
                            </div>
                            <div class="text-right">
                                <div class="text-sm text-slate-500 dark:text-slate-400">{{ number_format($app->downloads_count) }}</div>
                                <div class="text-xs text-slate-400">{{ __('Downloads') }}</div>
                            </div>
                        </div>

                        <p class="mt-4 line-clamp-3 text-sm text-slate-600 dark:text-slate-400">{{ Str::limit($app->getTranslatedDescription(), 140) }}</p>

                        <div class="mt-4 flex items-center justify-between text-xs text-slate-500 dark:text-slate-400">
                            <span>{{ __('Version') }} {{ $app->latest_version }}</span>
                            <span>{{ __('Rank') }} #{{ (($apps->currentPage() - 1) * $apps->perPage()) + $loop->index + 1 }}</span>
                        </div>

                        <div class="mt-5 flex gap-3">
                            <a href="{{ route('download.show', $app->slug) }}" class="flex-1 rounded-xl bg-indigo-600 px-4 py-2 text-center text-sm font-semibold text-white hover:bg-indigo-500">{{ __('Download') }}</a>
                            <a href="{{ route('apps.show', $app->slug) }}" class="flex-1 rounded-xl border border-slate-200 px-4 py-2 text-center text-sm font-semibold text-slate-700 dark:border-slate-700 dark:text-slate-100">{{ __('Details') }}</a>
                        </div>
                    </div>
                @endforeach
            </div>

            <div class="mt-10 flex justify-center">
                {{ $apps->links() }}
            </div>
        @else
            <div class="rounded-3xl border border-slate-100 bg-white/80 p-12 text-center dark:border-slate-800 dark:bg-slate-900/60">
                <p class="text-4xl">😕</p>
                <h2 class="mt-4 text-2xl font-bold text-slate-900 dark:text-white">{{ __('No popular apps found at the moment.') }}</h2>
                <p class="mt-2 text-slate-500 dark:text-slate-400">{{ __('Check back later; popular apps will appear as downloads accumulate.') }}</p>
            </div>
        @endif
    </section>
@endsection
