@extends('layouts.app')

@section('title', $title)

@section('content')
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8">
    <div class="container mx-auto px-4">
        <!-- Category Header -->
        <div class="mb-8 rounded-3xl border border-slate-100 bg-white p-6 shadow-sm dark:border-slate-800 dark:bg-slate-900">
            <div class="flex flex-col gap-6 md:flex-row md:items-center md:justify-between">
                <div>
                    <p class="text-sm font-semibold uppercase tracking-wide text-indigo-500">{{ __('Category') }}</p>
                    <h1 class="mt-2 text-3xl font-bold text-slate-900 dark:text-white">{{ $category->getTranslatedName() }}</h1>
                    <p class="mt-2 text-slate-500 dark:text-slate-400">{{ $category->getTranslatedDescription() }}</p>
                    <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">{{ $category->apps_count }} {{ __('apps available') }}</p>
                </div>
                <div class="text-6xl">
                    @include('components.category-icon', ['slug' => $category->slug, 'color' => ''])
                </div>
            </div>
        </div>

        <!-- Apps Grid -->
        @if($apps->count() > 0)
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6 mb-8">
            @foreach($apps as $app)
            <div class="bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition">
                <a href="{{ route('apps.show', $app->slug) }}" class="block">
                    <div class="p-6">
                        <div class="flex items-start space-x-4">
                            <img src="{{ $app->icon_url ?: asset('images/default-icon.png') }}"
                                 alt="{{ $app->getTranslatedName() }}"
                                 class="w-20 h-20 rounded-lg">
                            <div class="flex-1">
                                <h3 class="text-lg font-semibold text-gray-900 dark:text-white mb-2">{{ $app->getTranslatedName() }}</h3>
                                <p class="text-sm text-gray-600 dark:text-gray-400 mb-3 line-clamp-2">{{ $app->getTranslatedDescription() }}</p>
                                <div class="flex items-center justify-between text-sm">
                                    <span class="text-blue-600 dark:text-blue-400">{{ $app->getTranslatedName() }}</span>
                                    <div class="flex items-center space-x-2">
                                        <span class="text-yellow-400">★</span>
                                        <span class="text-gray-600 dark:text-gray-400">{{ number_format($app->rating, 1) }}</span>
                                    </div>
                                </div>
                                <div class="mt-2 text-xs text-gray-500 dark:text-gray-400">
                                    {{ $app->latest_version }} • {{ $app->updated_at->diffForHumans() }}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="px-6 py-3 bg-gray-50 dark:bg-gray-700 border-t border-gray-200 dark:border-gray-600">
                        <div class="flex items-center justify-between">
                            <span class="text-sm text-gray-600 dark:text-gray-400">{{ number_format($app->downloads_count) }} {{ __('downloads') }}</span>
                            <span class="text-sm font-medium text-blue-600 dark:text-blue-400">{{ __('Download') }}</span>
                        </div>
                    </div>
                </a>
            </div>
            @endforeach
        </div>

        <!-- Pagination -->
        <div class="flex justify-center">
            {{ $apps->links() }}
        </div>
        @else
        <div class="text-center py-12">
            <div class="text-gray-400 mb-4">
                <svg class="mx-auto h-12 w-12" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
            </div>
            <h3 class="text-lg font-medium text-gray-900 dark:text-white mb-2">{{ __('No apps in this category') }}</h3>
            <p class="text-gray-600 dark:text-gray-400">{{ __('There are no apps available in this category yet.') }}</p>
        </div>
        @endif

        <!-- Related Categories -->
        <div class="mt-12">
            <h2 class="text-xl font-semibold text-gray-900 dark:text-white mb-6">{{ __('Other Categories') }}</h2>
            @if($relatedCategories->count() > 0)
            <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
                @foreach($relatedCategories as $relatedCategory)
                <a href="{{ route('apps.category', $relatedCategory->slug) }}"
                   class="bg-white dark:bg-gray-800 rounded-lg shadow-md hover:shadow-lg transition p-4 text-center">
                    <div class="text-2xl mb-2">
                        @include('components.category-icon', ['slug' => $relatedCategory->slug, 'color' => ''])
                    </div>
                    <h3 class="text-sm font-semibold text-gray-900 dark:text-white">{{ $relatedCategory->getTranslatedName() }}</h3>
                    <p class="text-xs text-gray-600 dark:text-gray-400 mt-1">{{ $relatedCategory->apps_count }} {{ __('apps') }}</p>
                </a>
                @endforeach
            </div>
            @endif
        </div>
    </div>
</div>
@endsection
