@extends('layouts.app')

@section('title', $title)

@section('content')
<!-- Main container with explicit RTL direction -->
<div class="min-h-screen bg-gray-50 dark:bg-gray-900 py-8">
    <div class="container mx-auto px-4 sm:px-6 lg:px-8">

        <!-- Header & Search Bar -->
        <div class="mb-12 bg-white dark:bg-gray-800 p-6 rounded-xl shadow-lg">
            <h1 class="text-4xl font-extrabold text-gray-900 dark:text-white mb-2 border-b border-blue-100 dark:border-gray-700 pb-2">
                {{ $title }}
            </h1>
            <p class="text-lg text-gray-600 dark:text-gray-400 mb-6">{{ __('Discover and browse thousands of apps across various categories.') }}</p>

            <div class="md:flex md:items-center md:justify-between space-y-4 md:space-y-0">
                <!-- Search Form -->
                <form action="{{ route('apps.search') }}" method="GET" class="flex w-full md:w-1/2 max-w-lg shadow-md rounded-xl overflow-hidden">
                    <input type="text" name="q" placeholder="{{ __('Search for apps or categories...') }}"
                           class="w-full px-5 py-3 border-0 bg-white dark:bg-gray-700 text-gray-900 dark:text-white focus:ring-0"
                           value="{{ request('q') }}">
                    <button type="submit" class="px-5 py-3 bg-blue-600 text-white hover:bg-blue-700 transition duration-150 flex items-center justify-center">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                        </svg>
                    </button>
                </form>

                <!-- Navigation Links -->
                <div class="flex items-center space-x-6 rtl:space-x-reverse text-sm font-medium">
                    <a href="{{ route('apps.latest') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 transition duration-150 p-2 rounded-lg hover:bg-blue-50 dark:hover:bg-gray-700">
                        {{ __('Latest Apps') }}
                    </a>
                    <a href="{{ route('apps.popular') }}" class="text-blue-600 dark:text-blue-400 hover:text-blue-800 dark:hover:text-blue-300 transition duration-150 p-2 rounded-lg hover:bg-blue-50 dark:hover:bg-gray-700">
                        {{ __('Popular Apps') }}
                    </a>
                </div>
            </div>
        </div>

        <!-- Categories Grid -->
        @if($categories->count() > 0)
        <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6">{{ __('All Categories') }}</h2>

        <div class="grid grid-cols-2 sm:grid-cols-3 lg:grid-cols-4 xl:grid-cols-6 gap-6 mb-12">
            @foreach($categories as $category)
            <a href="{{ route('apps.category', $category->slug) }}"
               class="bg-white dark:bg-gray-800 rounded-xl border border-gray-100 dark:border-gray-700 shadow-md hover:shadow-xl hover:border-blue-300 dark:hover:border-blue-600 transition duration-300 p-6 text-center group flex flex-col justify-between h-full transform hover:scale-[1.02]">

                <!-- Icon and Animation -->
                <div class="flex-shrink-0">
                    <div class="text-4xl mb-4 mx-auto w-16 h-16 flex items-center justify-center rounded-full bg-blue-50 dark:bg-gray-700 group-hover:bg-blue-100 transition-colors">
                        @include('components.category-icon', ['slug' => $category->slug, 'color' => $category->color ?? 'text-blue-600'])
                    </div>
                </div>

                <!-- Name and Count -->
                <div class="flex-1 mt-4">
                    <h3 class="text-lg font-bold text-gray-900 dark:text-white mb-2 group-hover:text-blue-600 dark:group-hover:text-blue-400 transition">
                        {{ $category->getTranslatedName() }}
                    </h3>
                    <p class="text-sm text-gray-600 dark:text-gray-400">
                        {{ $category->apps_count }} {{ __('apps') }}
                    </p>
                </div>

                <!-- Description (Optional) -->
                @if($category->getTranslatedDescription())
                <p class="text-xs text-gray-500 dark:text-gray-500 mt-3 line-clamp-2 leading-relaxed">
                    {{ $category->getTranslatedDescription() }}
                </p>
                @endif

                <!-- CTA -->
                <div class="mt-4 text-sm font-semibold text-blue-600 dark:text-blue-400 flex items-center justify-center">
                    {{ __('Browse') }}
                    <!-- RTL Arrow (using mr-1 for spacing to the right of the text) -->
                    <svg class="w-4 h-4 mr-1 transform rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                    </svg>
                </div>
            </a>
            @endforeach
        </div>

        <!-- Categories Stats -->
        <div class="mt-12">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6">{{ __('Platform Statistics') }}</h2>
            <div class="grid grid-cols-1 sm:grid-cols-2 md:grid-cols-3 gap-6">
                <!-- Stat Card: Total Categories -->
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 text-center border-b-4 border-blue-500">
                    <div class="text-blue-600 dark:text-blue-400 mb-3 mx-auto w-10 h-10 flex items-center justify-center bg-blue-50 dark:bg-blue-900/20 rounded-full">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M7 7h10m0 0v10m0-10l-6 6M7 7l6 6"></path>
                        </svg>
                    </div>
                    <div class="text-4xl font-extrabold text-gray-900 dark:text-white mb-1">
                        {{ $categories->count() }}
                    </div>
                    <div class="text-gray-600 dark:text-gray-400 font-medium">{{ __('Total Categories') }}</div>
                </div>

                <!-- Stat Card: Total Apps -->
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 text-center border-b-4 border-green-500">
                    <div class="text-green-600 dark:text-green-400 mb-3 mx-auto w-10 h-10 flex items-center justify-center bg-green-50 dark:bg-green-900/20 rounded-full">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2V6zM14 6a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2V6zM4 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2H6a2 2 0 01-2-2v-2zM14 16a2 2 0 012-2h2a2 2 0 012 2v2a2 2 0 01-2 2h-2a2 2 0 01-2-2v-2z"></path>
                        </svg>
                    </div>
                    <div class="text-4xl font-extrabold text-gray-900 dark:text-white mb-1">
                        {{ number_format($categories->sum('apps_count')) }}
                    </div>
                    <div class="text-gray-600 dark:text-gray-400 font-medium">{{ __('Total Apps Available') }}</div>
                </div>

                <!-- Stat Card: Avg Apps per Category -->
                <div class="bg-white dark:bg-gray-800 rounded-xl shadow-lg p-6 text-center border-b-4 border-purple-500">
                    <div class="text-purple-600 dark:text-purple-400 mb-3 mx-auto w-10 h-10 flex items-center justify-center bg-purple-50 dark:bg-purple-900/20 rounded-full">
                        <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c1.657 0 3 .895 3 2s-1.343 2-3 2M9 10h.01M21 12a9 9 0 11-18 0 9 9 0 0118 0zM7 20h10a1 1 0 001-1V5a1 1 0 00-1-1H7a1 1 0 00-1 1v14a1 1 0 001 1z"></path>
                        </svg>
                    </div>
                    <div class="text-4xl font-extrabold text-gray-900 dark:text-white mb-1">
                        {{ number_format($categories->avg('apps_count'), 1) }}
                    </div>
                    <div class="text-gray-600 dark:text-gray-400 font-medium">{{ __('Avg Apps per Category') }}</div>
                </div>
            </div>
        </div>

        <!-- Popular Categories (Using the unified icon component) -->
        <div class="mt-16">
            <h2 class="text-2xl font-bold text-gray-900 dark:text-white mb-6 border-b border-gray-200 dark:border-gray-700 pb-3">{{ __('Trending Categories') }}</h2>
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-6">
                <!-- Sort categories by apps_count descending and take top 6 -->
                @foreach($categories->sortByDesc('apps_count')->take(6) as $category)
                <a href="{{ route('apps.category', $category->slug) }}"
                   class="flex items-center space-x-4 rtl:space-x-reverse bg-white dark:bg-gray-800 rounded-xl shadow-md hover:shadow-lg hover:border-blue-400 border border-transparent transition p-5 transform hover:-translate-y-1">

                    <!-- Unified Icon Inclusion -->
                    <div class="text-2xl flex-shrink-0 w-12 h-12 flex items-center justify-center rounded-lg bg-blue-50 dark:bg-gray-700">
                        @include('components.category-icon', ['slug' => $category->slug, 'color' => $category->color ?? 'text-blue-600'])
                    </div>

                    <div class="flex-1 text-right">
                        <h3 class="font-bold text-lg text-gray-900 dark:text-white group-hover:text-blue-600 dark:group-hover:text-blue-400">
                            {{ $category->getTranslatedName() }}
                        </h3>
                        <p class="text-sm text-gray-600 dark:text-gray-400 mt-1">
                            {{ $category->apps_count }} {{ __('apps available') }}
                        </p>
                    </div>

                    <!-- Arrow Icon -->
                    <div class="text-blue-600 dark:text-blue-400 flex-shrink-0">
                        <!-- RTL Arrow -->
                        <svg class="w-6 h-6 transform rotate-180" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 19l-7-7 7-7"></path>
                        </svg>
                    </div>
                </a>
                @endforeach
            </div>
        </div>

        @else
        <!-- No Categories Found Message -->
        <div class="text-center py-20 bg-white dark:bg-gray-800 rounded-xl shadow-lg">
            <div class="text-gray-400 mb-4">
                <svg class="mx-auto h-16 w-16" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 11H5m14 0a2 2 0 012 2v6a2 2 0 01-2 2H5a2 2 0 01-2-2v-6a2 2 0 012-2m14 0V9a2 2 0 00-2-2M5 11V9a2 2 0 012-2m0 0V5a2 2 0 012-2h6a2 2 0 012 2v2M7 7h10"></path>
                </svg>
            </div>
            <h3 class="text-xl font-bold text-gray-900 dark:text-white mb-2">{{ __('No categories found') }}</h3>
            <p class="text-gray-600 dark:text-gray-400">{{ __('Please add categories through the admin panel to populate the store.') }}</p>
        </div>
        @endif

    </div>
</div>
@endsection
