@extends('layouts.app')

@section('title', __('Admin Dashboard'))

@section('content')
    <section class="bg-gradient-to-br from-slate-900 via-indigo-900 to-purple-800 py-14 text-white">
        <div class="mx-auto max-w-6xl px-6 text-center">
            <p class="text-xs font-semibold uppercase tracking-[0.5em] text-indigo-200">{{ __('Administrative') }}</p>
            <h1 class="mt-4 text-4xl font-bold">{{ __('APK Center Admin Panel') }}</h1>
            <p class="mt-3 text-slate-200">
                {{ __('Monitor the catalog, sync new apps, and keep the site’s data fresh from a single workspace.') }}
            </p>
        </div>
    </section>

    <div class="mx-auto max-w-6xl space-y-8 px-6 py-12">
        @if(session('status'))
            <div class="rounded-2xl border border-emerald-200 bg-emerald-50 p-4 text-sm text-emerald-900">
                {{ session('status') }}
            </div>
        @endif

        <div class="rounded-3xl border border-indigo-100 bg-indigo-50 p-6 text-slate-900 shadow-sm dark:border-indigo-900 dark:bg-slate-900 dark:text-white">
            <h2 class="text-xl font-semibold">{{ __('Secured administrator access') }}</h2>
            <p class="mt-2 text-sm text-slate-700 dark:text-slate-200">
                {{ __('The admin routes now require either a signed-in administrator account or valid HTTP Basic credentials.') }}
            </p>
            <ul class="mt-3 space-y-1 text-sm text-slate-700 dark:text-slate-300">
                <li>{{ __('Existing admin users stay signed in if they have the :flag flag.', ['flag' => 'is_admin']) }}</li>
                <li>{{ __('Default Basic user: :user', ['user' => config('admin.username')]) }}</li>
                <li>{{ __('Update Basic credentials via the :env file (ADMIN_USERNAME & ADMIN_PASSWORD).', ['env' => '.env']) }}</li>
            </ul>
        </div>

        <div class="grid gap-6 sm:grid-cols-2 lg:grid-cols-4">
            <article class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-xs uppercase tracking-widest text-slate-500 dark:text-slate-400">{{ __('Apps catalog') }}</p>
                <p class="mt-4 text-3xl font-bold text-slate-900 dark:text-white">{{ number_format($stats['apps']) }}</p>
                <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Active listings') }}</p>
            </article>
            <article class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-xs uppercase tracking-widest text-slate-500 dark:text-slate-400">{{ __('Categories') }}</p>
                <p class="mt-4 text-3xl font-bold text-slate-900 dark:text-white">{{ number_format($stats['categories']) }}</p>
                <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Curated sections') }}</p>
            </article>
            <article class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-xs uppercase tracking-widest text-slate-500 dark:text-slate-400">{{ __('Downloads') }}</p>
                <p class="mt-4 text-3xl font-bold text-slate-900 dark:text-white">{{ number_format($stats['total_downloads']) }}</p>
                <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Total served') }}</p>
            </article>
            <article class="rounded-3xl border border-slate-100 bg-white p-6 text-center shadow-sm dark:border-slate-800 dark:bg-slate-900">
                <p class="text-xs uppercase tracking-widest text-slate-500 dark:text-slate-400">{{ __('Last sync') }}</p>
                <p class="mt-4 text-3xl font-bold text-slate-900 dark:text-white">
                    {{ $stats['latest_update'] ? $stats['latest_update']->diffForHumans() : __('No records yet') }}
                </p>
                <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Latest app refresh') }}</p>
            </article>
        </div>

        <div class="grid gap-8 lg:grid-cols-[1.1fr_0.9fr]">
            <div class="rounded-3xl border border-slate-100 bg-white p-8 shadow-lg dark:border-slate-800 dark:bg-slate-900">
                <h2 class="text-2xl font-bold text-slate-900 dark:text-white">{{ __('Import queue') }}</h2>
                <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">
                    {{ __('Trigger the app import routine and control which source or force update you need.') }}
                </p>

                <form action="{{ route('admin.import') }}" method="POST" class="mt-6 space-y-4">
                    @csrf
                    <div class="space-y-2">
                        <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Source') }}</label>
                        <select name="source" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-3 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white">
                            <option value="">{{ __('All sources') }}</option>
                            @foreach($importSources as $sourceKey => $source)
                                @php
                                    $sourceOrigin = $source['base_url'] ?? $source['feed_url'] ?? __('Remote feed');
                                @endphp
                                <option value="{{ $sourceKey }}">{{ $source['name'] }} ({{ $sourceOrigin }})</option>
                            @endforeach
                        </select>
                    </div>

                    <label class="inline-flex items-center gap-2 text-sm text-slate-500 dark:text-slate-300">
                        <input type="checkbox" name="force" value="1" class="h-4 w-4 rounded border-slate-300 text-indigo-600 focus:ring-indigo-500">
                        {{ __('Force update') }}
                    </label>

                    <button type="submit" class="w-full rounded-2xl bg-gradient-to-r from-indigo-600 to-purple-600 px-6 py-3 text-base font-semibold text-white shadow-lg transition hover:from-indigo-500 hover:to-purple-500">
                        {{ __('Run Import Now') }}
                    </button>
                </form>
            </div>

            <div class="space-y-4">
                @if(!empty($importSources))
                    @foreach($importSources as $sourceKey => $source)
                        <article class="rounded-3xl border border-slate-100 bg-white p-6 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                            <div class="flex items-center justify-between">
                                <div>
                                    <h3 class="text-lg font-semibold text-slate-900 dark:text-white">{{ $source['name'] }}</h3>
                                    <p class="text-xs text-slate-500 dark:text-slate-400">{{ $source['description'] }}</p>
                                </div>
                                <span class="rounded-full border px-3 py-1 text-xs font-semibold text-slate-700 dark:text-slate-300 brand-badge"
                                      style="--brand-color: {{ $source['brand_color'] ?? '#cbd5f5' }}">
                                    {{ $source['type'] ?? __('Adapter') }}
                                </span>
                            </div>

                            <p class="mt-3 text-sm text-slate-500 dark:text-slate-300">
                                {{ $source['base_url'] ?? $source['feed_url'] ?? __('Remote feed') }}
                            </p>

                            <form action="{{ route('admin.import') }}" method="POST" class="mt-6 space-y-3">
                                @csrf
                                <input type="hidden" name="source" value="{{ $sourceKey }}">
                                <button type="submit"
                                        class="w-full rounded-2xl bg-gradient-to-r from-indigo-600 to-purple-600 px-4 py-2 text-sm font-semibold text-white shadow-lg transition hover:brightness-110">
                                    {{ __('Sync :source now', ['source' => $source['name']]) }}
                                </button>
                            </form>
                        </article>
                    @endforeach
                @else
                    <div class="rounded-3xl border border-slate-100 bg-white p-6 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                        <p class="text-sm text-slate-500 dark:text-slate-300">{{ __('No import sources are configured yet.') }}</p>
                    </div>
                @endif
            </div>
        </div>
    </div>
@endsection