@extends('layouts.app')

@section('title', __('APK Import'))

@section('content')
    <section class="bg-gradient-to-br from-slate-900 via-indigo-900 to-purple-800 py-14 text-white">
        <div class="mx-auto max-w-6xl px-6 text-center">
            <p class="text-xs font-semibold uppercase tracking-[0.5em] text-indigo-200">{{ __('Administrative') }}</p>
            <h1 class="mt-4 text-4xl font-bold">{{ __('APK Import Playground') }}</h1>
            <p class="mt-3 text-slate-200">
                {{ __('Search any supported source, preview the scraped drafts, and push valid ones into the import session.') }}
            </p>
        </div>
    </section>

    <div class="mx-auto max-w-6xl space-y-6 px-6 py-10">
        @if(session('status'))
            <div class="rounded-2xl border border-emerald-200 bg-emerald-50 p-4 text-sm text-emerald-900">
                {{ session('status') }}
            </div>
        @endif

        @if($statusMessage)
            <div class="rounded-2xl border border-emerald-200 bg-emerald-50 p-4 text-sm text-emerald-900">
                {{ $statusMessage }}
                <span class="ml-2 text-xs text-emerald-700">{{ __('Valid drafts are stored for the main import flow.') }}</span>
            </div>
        @endif

        @if($errorMessage)
            <div class="rounded-2xl border border-rose-200 bg-rose-50 p-4 text-sm text-rose-900">
                {{ $errorMessage }}
            </div>
        @endif

        <div class="grid gap-8 lg:grid-cols-[0.9fr_1.1fr]">
            <div class="rounded-3xl border border-slate-100 bg-white p-8 shadow-lg dark:border-slate-800 dark:bg-slate-900">
                <h2 class="text-2xl font-bold text-slate-900 dark:text-white">{{ __('Scrape drafts') }}</h2>
                <p class="mt-2 text-sm text-slate-500 dark:text-slate-400">
                    {{ __('Choose a source, type a query, and pull fresh drafts without leaving the dashboard.') }}
                </p>

                <form action="{{ route('admin.apk-import') }}" method="GET" class="mt-6 space-y-5">
                    <div class="space-y-2">
                        <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Source') }}</label>
                        <select name="source" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-3 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white">
                            <option value="">{{ __('Select a scraper source') }}</option>
                            @foreach($sources as $key => $source)
                                <option value="{{ $key }}" @selected($selectedSource === $key)>
                                    {{ $source['name'] }} — {{ $source['description'] ?? $source['url'] ?? '' }}
                                </option>
                            @endforeach
                        </select>
                        @error('source')
                            <p class="text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <div class="space-y-2">
                        <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Query') }}</label>
                        <input type="text" name="query" value="{{ $query }}" placeholder="{{ __('e.g. whatsapp or owner/repo for GitHub') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-3 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" />
                        <p class="text-xs text-slate-500 dark:text-slate-400">{{ __('GitHub expects owner/repo, while APKPure/APKMirror accept app names or package IDs.') }}</p>
                        @error('query')
                            <p class="text-xs text-rose-600">{{ $message }}</p>
                        @enderror
                    </div>

                    <button type="submit" class="w-full rounded-2xl bg-gradient-to-r from-indigo-600 to-purple-600 px-6 py-3 text-base font-semibold text-white shadow-lg transition hover:from-indigo-500 hover:to-purple-500">
                        {{ __('Search and scrape') }}
                    </button>
                </form>
            </div>

            <div class="space-y-4">
                <div class="flex items-center justify-between">
                    <div>
                        <h3 class="text-lg font-semibold text-slate-900 dark:text-white">{{ __('Scraped drafts') }}</h3>
                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Validated drafts are automatically queued into the apk-import session.') }}</p>
                    </div>
                    <span class="rounded-full border px-3 py-1 text-xs font-semibold text-slate-700 dark:text-slate-300">{{ __('Results: :count', ['count' => count($drafts)]) }}</span>
                </div>

                @if(empty($drafts))
                    <div class="rounded-3xl border border-dashed border-slate-200 bg-white p-8 text-center text-slate-500 shadow-sm dark:border-slate-800 dark:bg-slate-900 dark:text-slate-300">
                        {{ __('Start by selecting a source and query to see scraped results here.') }}
                    </div>
                @else
                    <div class="space-y-4">
                        @foreach($drafts as $draft)
                            <article class="rounded-3xl border border-slate-100 bg-white p-6 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                                <div class="flex items-start justify-between gap-4">
                                    <div>
                                        <p class="text-xs uppercase tracking-[0.3em] text-slate-500 dark:text-slate-400">{{ strtoupper($draft['source'] ?? $selectedSource) }}</p>
                                        <h4 class="text-xl font-semibold text-slate-900 dark:text-white">{{ $draft['name'] ?? __('Unknown app') }}</h4>
                                        <p class="text-sm text-slate-500 dark:text-slate-400">{{ $draft['developer'] ?? __('Unknown developer') }}</p>
                                    </div>
                                    @empty($draft['validation_errors'])
                                        <span class="rounded-full bg-emerald-100 px-3 py-1 text-xs font-semibold text-emerald-800 dark:bg-emerald-900/40 dark:text-emerald-200">{{ __('Ready to import') }}</span>
                                    @else
                                        <span class="rounded-full bg-amber-100 px-3 py-1 text-xs font-semibold text-amber-800 dark:bg-amber-900/40 dark:text-amber-200">{{ __('Needs review') }}</span>
                                    @endempty
                                </div>

                                <dl class="mt-4 grid gap-3 sm:grid-cols-2">
                                    <div>
                                        <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Package') }}</dt>
                                        <dd class="text-sm font-semibold text-slate-900 dark:text-white">{{ $draft['package_name'] ?? '—' }}</dd>
                                    </div>
                                    <div>
                                        <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Version') }}</dt>
                                        <dd class="text-sm font-semibold text-slate-900 dark:text-white">{{ $draft['latest_version'] ?? '—' }}</dd>
                                    </div>
                                    <div>
                                        <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Rating') }}</dt>
                                        <dd class="text-sm font-semibold text-slate-900 dark:text-white">{{ $draft['rating'] ?? __('N/A') }}</dd>
                                    </div>
                                    <div>
                                        <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Download URL') }}</dt>
                                        <dd class="text-sm font-semibold text-indigo-600 dark:text-indigo-300 break-all">
                                            @if(!empty($draft['download_url']))
                                                <a href="{{ $draft['download_url'] }}" target="_blank" rel="noopener">{{ $draft['download_url'] }}</a>
                                            @else
                                                <span class="text-slate-500 dark:text-slate-400">{{ __('Not provided') }}</span>
                                            @endif
                                        </dd>
                                    </div>
                                </dl>

                                @if(!empty($draft['validation_errors']))
                                    <div class="mt-4 rounded-2xl border border-amber-200 bg-amber-50 p-4 text-sm text-amber-900 dark:border-amber-900/50 dark:bg-amber-900/30 dark:text-amber-100">
                                        <p class="font-semibold">{{ __('Validation warnings') }}</p>
                                        <ul class="mt-2 list-disc space-y-1 pl-5">
                                            @foreach($draft['validation_errors'] as $warning)
                                                <li>{{ $warning }}</li>
                                            @endforeach
                                        </ul>
                                    </div>
                                @endif

                                @if(!empty($draft['source_url']))
                                    <a href="{{ $draft['source_url'] }}" target="_blank" rel="noopener" class="mt-4 inline-flex items-center gap-2 text-sm font-semibold text-indigo-600 hover:text-indigo-500 dark:text-indigo-300 dark:hover:text-indigo-200">
                                        {{ __('View source page') }}
                                        <svg class="h-4 w-4" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5">
                                            <path stroke-linecap="round" stroke-linejoin="round" d="M5 12h14m0 0-4-4m4 4-4 4" />
                                        </svg>
                                    </a>
                                @endif
                            </article>
                        @endforeach
                    </div>
                @endif
            </div>
        </div>

        @php($storedDrafts = $sessionDrafts ?? [])

        <div class="rounded-3xl border border-slate-100 bg-white p-6 shadow-lg dark:border-slate-800 dark:bg-slate-900">
            <div class="flex items-center justify-between">
                <div>
                    <h3 class="text-lg font-semibold text-slate-900 dark:text-white">{{ __('Stored drafts (session)') }}</h3>
                    <p class="text-sm text-slate-500 dark:text-slate-400">{{ __('Edit or review the drafts saved for import before continuing.') }}</p>
                </div>
                <span class="rounded-full border px-3 py-1 text-xs font-semibold text-slate-700 dark:text-slate-300">{{ __('Drafts: :count', ['count' => count($storedDrafts)]) }}</span>
            </div>

            @if(empty($storedDrafts))
                <div class="mt-4 rounded-2xl border border-dashed border-slate-200 bg-white p-6 text-center text-sm text-slate-500 dark:border-slate-800 dark:bg-slate-900 dark:text-slate-300">
                    {{ __('No drafts have been stored yet. Scrape a source to start populating this section.') }}
                </div>
            @else
                <div class="mt-4 grid gap-4 md:grid-cols-2">
                    @foreach($storedDrafts as $index => $draft)
                        <article class="relative rounded-2xl border border-slate-100 bg-white p-5 shadow-sm dark:border-slate-800 dark:bg-slate-900">
                            <div class="flex items-start justify-between gap-3">
                                <div>
                                    <p class="text-xs uppercase tracking-[0.3em] text-slate-500 dark:text-slate-400">{{ strtoupper($draft['source'] ?? __('Session')) }}</p>
                                    <h4 class="text-lg font-semibold text-slate-900 dark:text-white">{{ $draft['name'] ?? __('Unknown app') }}</h4>
                                    <p class="text-sm text-slate-500 dark:text-slate-400">{{ $draft['developer'] ?? __('Unknown developer') }}</p>
                                </div>
                                <a href="{{ route('admin.apk-import.drafts.edit', $index) }}" class="rounded-full border border-indigo-200 bg-indigo-50 px-3 py-1 text-xs font-semibold text-indigo-700 transition hover:border-indigo-300 hover:bg-indigo-100 dark:border-indigo-800 dark:bg-indigo-900/50 dark:text-indigo-200 dark:hover:border-indigo-700 dark:hover:bg-indigo-900">
                                    {{ __('Edit') }}
                                </a>
                            </div>

                            <dl class="mt-3 space-y-2 text-sm text-slate-700 dark:text-slate-200">
                                <div class="flex items-center justify-between">
                                    <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Package') }}</dt>
                                    <dd class="font-semibold">{{ $draft['package_name'] ?? '—' }}</dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Version') }}</dt>
                                    <dd class="font-semibold">{{ $draft['latest_version'] ?? '—' }}</dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Rating') }}</dt>
                                    <dd class="font-semibold">{{ $draft['rating'] ?? __('N/A') }}</dd>
                                </div>
                                <div class="flex items-center justify-between">
                                    <dt class="text-xs uppercase tracking-[0.2em] text-slate-500 dark:text-slate-400">{{ __('Download URL') }}</dt>
                                    <dd class="truncate text-indigo-600 dark:text-indigo-300">{{ $draft['download_url'] ?? __('Not provided') }}</dd>
                                </div>
                            </dl>

                            @if(isset($editingIndex, $editingDraft) && $editingIndex === $index)
                                <div class="fixed inset-0 z-40 flex items-center justify-center bg-black/40 px-4 py-6">
                                    <div class="w-full max-w-2xl overflow-hidden rounded-2xl bg-white shadow-2xl dark:bg-slate-900">
                                        <div class="flex items-center justify-between border-b border-slate-200 bg-slate-50 px-6 py-4 dark:border-slate-800 dark:bg-slate-800">
                                            <div>
                                                <p class="text-xs uppercase tracking-[0.3em] text-slate-500 dark:text-slate-400">{{ __('Edit draft') }}</p>
                                                <h3 class="text-lg font-semibold text-slate-900 dark:text-white">{{ $editingDraft['name'] ?? __('Draft') }}</h3>
                                            </div>
                                            <a href="{{ route('admin.apk-import') }}" class="text-sm font-semibold text-slate-500 transition hover:text-slate-700 dark:text-slate-300 dark:hover:text-white">{{ __('Cancel') }}</a>
                                        </div>

                                        <form action="{{ route('admin.apk-import.drafts.update', $index) }}" method="POST" class="space-y-4 px-6 py-5">
                                            @csrf
                                            @method('PUT')

                                            @if($errors->any())
                                                <div class="rounded-2xl border border-rose-200 bg-rose-50 p-3 text-sm text-rose-900 dark:border-rose-900/50 dark:bg-rose-900/30 dark:text-rose-100">
                                                    <p class="font-semibold">{{ __('Please fix the errors below:') }}</p>
                                                    <ul class="mt-2 list-disc space-y-1 pl-5">
                                                        @foreach($errors->all() as $error)
                                                            <li>{{ $error }}</li>
                                                        @endforeach
                                                    </ul>
                                                </div>
                                            @endif

                                            <div class="grid gap-4 md:grid-cols-2">
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('App name') }}</label>
                                                    <input type="text" name="name" value="{{ old('name', $editingDraft['name'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" required />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Package name') }}</label>
                                                    <input type="text" name="package_name" value="{{ old('package_name', $editingDraft['package_name'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" required />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Developer') }}</label>
                                                    <input type="text" name="developer" value="{{ old('developer', $editingDraft['developer'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" required />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Version') }}</label>
                                                    <input type="text" name="latest_version" value="{{ old('latest_version', $editingDraft['latest_version'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" required />
                                                </div>
                                                <div class="space-y-1 md:col-span-2">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Download URL') }}</label>
                                                    <input type="url" name="download_url" value="{{ old('download_url', $editingDraft['download_url'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" required />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Rating') }}</label>
                                                    <input type="number" step="0.1" min="0" max="5" name="rating" value="{{ old('rating', $editingDraft['rating'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Size (bytes)') }}</label>
                                                    <input type="number" min="0" name="size" value="{{ old('size', $editingDraft['size'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Source URL') }}</label>
                                                    <input type="url" name="source_url" value="{{ old('source_url', $editingDraft['source_url'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" />
                                                </div>
                                                <div class="space-y-1">
                                                    <label class="text-sm font-semibold text-slate-600 dark:text-slate-300">{{ __('Source key') }}</label>
                                                    <input type="text" name="source" value="{{ old('source', $editingDraft['source'] ?? '') }}" class="w-full rounded-2xl border border-slate-200 bg-white px-4 py-2 text-sm text-slate-900 focus:border-indigo-500 focus:outline-none focus:ring-2 focus:ring-indigo-200 dark:border-slate-700 dark:bg-slate-800 dark:text-white" />
                                                </div>
                                            </div>

                                            <div class="flex items-center justify-end gap-3 border-t border-slate-200 pt-4 dark:border-slate-800">
                                                <a href="{{ route('admin.apk-import') }}" class="rounded-2xl border border-slate-200 px-4 py-2 text-sm font-semibold text-slate-600 transition hover:border-slate-300 hover:bg-slate-50 dark:border-slate-700 dark:text-slate-200 dark:hover:border-slate-600 dark:hover:bg-slate-800">{{ __('Cancel') }}</a>
                                                <button type="submit" class="rounded-2xl bg-gradient-to-r from-indigo-600 to-purple-600 px-5 py-2 text-sm font-semibold text-white shadow-lg transition hover:from-indigo-500 hover:to-purple-500">{{ __('Save changes') }}</button>
                                            </div>
                                        </form>
                                    </div>
                                </div>
                            @endif
                        </article>
                    @endforeach
                </div>
            @endif
        </div>
    </div>
@endsection