const getMetaContent = (name) => document.querySelector(`meta[name="${name}"]`)?.getAttribute('content');

const toggleTheme = (url, csrfToken) => {
    if (!url) {
        return;
    }

    fetch(url, {
        method: 'POST',
        headers: {
            'X-CSRF-TOKEN': csrfToken,
            'Accept': 'application/json',
            'X-Requested-With': 'XMLHttpRequest',
        },
    })
        .then((response) => response.json())
        .then((data) => {
            document.body.classList.toggle('dark', Boolean(data.is_dark_mode));
        })
        .catch(() => {});
};

const toggleMobileMenu = () => {
    document.getElementById('mobileMenu')?.classList.toggle('hidden');
};

document.addEventListener('DOMContentLoaded', () => {
    const csrfToken = getMetaContent('csrf-token');
    const darkModeUrl = getMetaContent('dark-mode-toggle-url');

    ['darkModeToggle', 'mobileDarkToggle'].forEach((id) => {
        document.getElementById(id)?.addEventListener('click', () => toggleTheme(darkModeUrl, csrfToken));
    });

    document.getElementById('mobileMenuToggle')?.addEventListener('click', toggleMobileMenu);
});
