<?php

namespace Database\Seeders;

use App\Models\User;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Str;

class DatabaseSeeder extends Seeder
{
    // لا نحتاج لاستخدام WithoutModelEvents هنا، يمكننا فقط تعطيل مراقبي الأحداث
    // إذا كنت تستخدمها في سياق معين، ولكن يفضل إزالتها في الـ Seeders العامة.

    /**
     * Seed the application's database.
     */
    public function run(): void
    {
        // 1. إنشاء مستخدم الإدارة الأساسي باستخدام updateOrCreate
        // هذا يضمن عدم حدوث خطأ التكرار (Unique Constraint Violation)
        // إذا تم تشغيل الـ Seeder أكثر من مرة.

        User::updateOrCreate(
            // الشروط للبحث (إذا وجد هذا البريد، فسيتم تحديثه)
            ['email' => 'test@example.com'],
            // البيانات التي سيتم إنشاؤها أو تحديثها
            [
                'name' => 'Test Admin',
                'password' => Hash::make('password'), // كلمة مرور آمنة للمطور
                'email_verified_at' => now(),
                'remember_token' => Str::random(10),
            ]
        );

        // 2. يمكنك هنا إضافة مصانع (Factories) لإنشاء مستخدمين عشوائيين إضافيين:
        // User::factory(10)->create();

        // 3. استدعاء الـ Seeders الأخرى
        $this->call([
            CategorySeeder::class,
            AppSeeder::class,
            // AppDetailsSeeder::class, // إذا كان لديك المزيد
        ]);
    }
}