<?php

namespace Database\Seeders;

use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;
use App\Models\Category;

class CategorySeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        $categories = [
            [
                'name' => 'Games',
                'slug' => 'games',
                'description' => 'Action, puzzle, strategy, and adventure games',
                'icon' => 'gamepad',
                'color' => '#FF6B6B',
                'sort_order' => 1,
                'status' => 'active',
            ],
            [
                'name' => 'Tools',
                'slug' => 'tools',
                'description' => 'Productivity utilities and system tools',
                'icon' => 'wrench',
                'color' => '#4ECDC4',
                'sort_order' => 2,
                'status' => 'active',
            ],
            [
                'name' => 'Social',
                'slug' => 'social',
                'description' => 'Social networking and communication apps',
                'icon' => 'users',
                'color' => '#45B7D1',
                'sort_order' => 3,
                'status' => 'active',
            ],
            [
                'name' => 'Entertainment',
                'slug' => 'entertainment',
                'description' => 'Music, video, and streaming applications',
                'icon' => 'play-circle',
                'color' => '#96CEB4',
                'sort_order' => 4,
                'status' => 'active',
            ],
            [
                'name' => 'Productivity',
                'slug' => 'productivity',
                'description' => 'Office apps and productivity tools',
                'icon' => 'briefcase',
                'color' => '#FFEAA7',
                'sort_order' => 5,
                'status' => 'active',
            ],
            [
                'name' => 'Education',
                'slug' => 'education',
                'description' => 'Learning and educational apps',
                'icon' => 'graduation-cap',
                'color' => '#DDA0DD',
                'sort_order' => 6,
                'status' => 'active',
            ],
            [
                'name' => 'Business',
                'slug' => 'business',
                'description' => 'Business and finance applications',
                'icon' => 'chart-line',
                'color' => '#98D8C8',
                'sort_order' => 7,
                'status' => 'active',
            ],
            [
                'name' => 'Health & Fitness',
                'slug' => 'health-fitness',
                'description' => 'Health tracking and fitness apps',
                'icon' => 'heart',
                'color' => '#FFB6C1',
                'sort_order' => 8,
                'status' => 'active',
            ],
            // إضافة فئات جديدة لتغطية جميع التطبيقات في AppSeeder
            [
                'name' => 'Communication',
                'slug' => 'communication',
                'description' => 'Email and instant messaging services',
                'icon' => 'comments',
                'color' => '#F4A460',
                'sort_order' => 9,
                'status' => 'active',
            ],
            [
                'name' => 'Photography',
                'slug' => 'photography',
                'description' => 'Tools for editing and sharing photos',
                'icon' => 'camera-retro',
                'color' => '#A9A9A9',
                'sort_order' => 10,
                'status' => 'active',
            ],
        ];

        foreach ($categories as $category) {
            // استخدام updateOrCreate للبحث عن فئة بواسطة 'slug' وإنشائها إذا لم توجد
            Category::updateOrCreate(
                ['slug' => $category['slug']],
                $category
            );
        }
    }
}