<?php

namespace Database\Seeders;

use Illuminate\Database\Seeder;
use App\Models\App;
use App\Models\Category;
use Illuminate\Support\Str;

class AppSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        // استخدام pluck('id', 'name') للحصول على مصفوفة ID => Name لسرعة البحث
        $categories = Category::pluck('id', 'name')->toArray();
        
        if (empty($categories)) {
            $this->command->warn('No categories found. Please ensure CategorySeeder is executed.');
            // نستخدم call للتأكد من تشغيل CategorySeeder إذا لم يتم استدعاؤه سابقاً
            // $this->call(CategorySeeder::class);
            // $categories = Category::pluck('id', 'name')->toArray();
            if (empty($categories)) {
                return;
            }
        }

        $sampleApps = [
            [
                'package_name' => 'com.whatsapp',
                'name' => 'WhatsApp Messenger',
                'description' => 'Simple. Reliable. Private. Messaging app.',
                'category_name' => 'Social',
                'developer' => 'WhatsApp LLC',
                'rating' => 4.5,
                'downloads_count' => 5000000000,
                'latest_version' => '2.24.12.81',
                'featured' => true,
            ],
            [
                'package_name' => 'com.instagram.android',
                'name' => 'Instagram',
                'description' => 'Connect with friends, share what you are up to.',
                'category_name' => 'Social',
                'developer' => 'Meta',
                'rating' => 4.2,
                'downloads_count' => 2000000000,
                'latest_version' => '316.0.0.37.114',
                'featured' => true,
            ],
            [
                'package_name' => 'com.facebook.katana',
                'name' => 'Facebook',
                'description' => 'Connect with friends, family and people who share the same interests.',
                'category_name' => 'Social',
                'developer' => 'Meta',
                'rating' => 4.1,
                'downloads_count' => 3000000000,
                'latest_version' => '470.0.0.36.74',
                'featured' => false,
            ],
            [
                'package_name' => 'com.google.android.youtube',
                'name' => 'YouTube',
                'description' => 'Enjoy your favorite videos and channels.',
                'category_name' => 'Entertainment',
                'developer' => 'Google LLC',
                'rating' => 4.3,
                'downloads_count' => 6000000000,
                'latest_version' => '19.45.36',
                'featured' => true,
            ],
            [
                'package_name' => 'com.supercell.clashofclans',
                'name' => 'Clash of Clans',
                'description' => 'Epic combat strategy game. Build your village, train your troops & go to battle!',
                'category_name' => 'Games',
                'developer' => 'Supercell',
                'rating' => 4.6,
                'downloads_count' => 500000000,
                'latest_version' => '16.0.12',
                'featured' => true,
            ],
            [
                'package_name' => 'com.king.candycrushsaga',
                'name' => 'Candy Crush Saga',
                'description' => 'Match and solve hundreds of delicious puzzles in this tasty puzzle adventure!',
                'category_name' => 'Games',
                'developer' => 'King',
                'rating' => 4.4,
                'downloads_count' => 1000000000,
                'latest_version' => '1.275.1.1',
                'featured' => false,
            ],
            [
                'package_name' => 'com.google.android.apps.docs.editors.docs',
                'name' => 'Google Docs',
                'description' => 'Create, edit & collaborate with others on documents.',
                'category_name' => 'Productivity',
                'developer' => 'Google LLC',
                'rating' => 4.3,
                'downloads_count' => 1000000000,
                'latest_version' => '1.24.432.00.90',
                'featured' => false,
            ],
            [
                'package_name' => 'com.spotify.music',
                'name' => 'Spotify',
                'description' => 'Listen to your favorite music and podcasts.',
                'category_name' => 'Entertainment', // تم تصحيح 'Music' إلى 'Entertainment' لتتوافق مع Seeder
                'developer' => 'Spotify AB',
                'rating' => 4.5,
                'downloads_count' => 2000000000,
                'latest_version' => '8.9.12.563',
                'featured' => true,
            ],
            [
                'package_name' => 'com.google.android.chrome',
                'name' => 'Google Chrome',
                'description' => 'Fast, secure, and smart web browser.',
                'category_name' => 'Tools',
                'developer' => 'Google LLC',
                'rating' => 4.3,
                'downloads_count' => 5000000000,
                'latest_version' => '131.0.6778.84',
                'featured' => false,
            ],
            [
                'package_name' => 'com.twitter.android',
                'name' => 'X (Twitter)',
                'description' => 'What\'s happening?!',
                'category_name' => 'Social',
                'developer' => 'X Corp.',
                'rating' => 3.8,
                'downloads_count' => 1000000000,
                'latest_version' => '10.46.0-release.0',
                'featured' => false,
            ],
            [
                'package_name' => 'com.netflix.mediaclient',
                'name' => 'Netflix',
                'description' => 'Watch TV shows and movies anytime, anywhere.',
                'category_name' => 'Entertainment',
                'developer' => 'Netflix, Inc.',
                'rating' => 4.4,
                'downloads_count' => 1000000000,
                'latest_version' => '8.134.0',
                'featured' => true,
            ],
            [
                'package_name' => 'com.google.android.gm',
                'name' => 'Gmail',
                // تم تغيير category_name من 'Communication' إلى 'Tools' لتتوافق مع الفئات المتاحة
                'description' => 'Email from Google.',
                'category_name' => 'Communication', 
                'developer' => 'Google LLC',
                'rating' => 4.2,
                'downloads_count' => 10000000000,
                'latest_version' => '2024.11.03.637839461.Release',
                'featured' => false,
            ],
            [
                'package_name' => 'com.google.android.apps.photos',
                'name' => 'Google Photos',
                'description' => 'Photo storage and sharing.',
                // تم تغيير category_name من 'Photography' إلى 'Tools' لتتوافق مع الفئات المتاحة
                'category_name' => 'Photography', 
                'developer' => 'Google LLC',
                'rating' => 4.5,
                'downloads_count' => 5000000000,
                'latest_version' => '6.85.0.662481885',
                'featured' => true,
            ],
        ];

        $appsCount = 0;
        foreach ($sampleApps as $appData) {
            $categoryName = $appData['category_name'];
            
            // التحقق مما إذا كانت الفئة موجودة في مصفوفة $categories
            if (!isset($categories[$categoryName])) {
                $this->command->warn("Category '{$categoryName}' not found. Skipping app '{$appData['name']}'.");
                continue;
            }

            // إعداد البيانات للإدخال
            $appToCreate = $appData;
            unset($appToCreate['category_name']); // إزالة الحقل المؤقت
            
            $appToCreate['slug'] = Str::slug($appToCreate['name']);
            $appToCreate['category_id'] = $categories[$categoryName];
            $appToCreate['size'] = rand(10000000, 200000000);
            $appToCreate['version_code'] = rand(100, 999);
            // استخدام رابط placeholder
            $appToCreate['icon_url'] = 'https://placehold.co/128x128/1bbc9b/ffffff?text=' . urlencode(substr($appToCreate['name'], 0, 1));

            // استخدام updateOrCreate للبحث عن التطبيق بواسطة 'package_name' ومنع التكرار
            App::updateOrCreate(
                ['package_name' => $appToCreate['package_name']],
                $appToCreate
            );
            $appsCount++;
        }

        $this->command->info($appsCount . ' apps seeded successfully (or updated).');
    }
}