<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('versions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('app_id')->constrained()->onDelete('cascade');
            $table->string('version_name');
            $table->integer('version_code');
            $table->date('release_date')->nullable();
            $table->text('changelog')->nullable();
            $table->string('download_url')->nullable();
            $table->bigInteger('size')->nullable();
            $table->string('min_os_version')->nullable();
            $table->string('max_os_version')->nullable();
            $table->enum('status', ['active', 'inactive', 'deprecated'])->default('active');
            $table->boolean('is_beta')->default(false);
            $table->timestamps();

            // Indexes
            $table->index('app_id');
            $table->index('version_code');
            $table->index('status');
            $table->index('is_beta');
            $table->index('release_date');

            // Unique constraint for app_id + version_code
            $table->unique(['app_id', 'version_code']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('versions');
    }
};