<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('apps', function (Blueprint $table) {
            $table->id();
            $table->string('package_name')->unique();
            $table->string('slug')->unique();
            $table->string('name');
            $table->text('description')->nullable();
            $table->string('icon_url')->nullable();
            $table->string('latest_version')->nullable();
            $table->decimal('rating', 3, 2)->default(0);
            $table->bigInteger('downloads_count')->default(0);
            $table->bigInteger('views_count')->default(0);
            $table->string('os_requirement')->nullable();
            $table->foreignId('category_id')->nullable()->constrained()->onDelete('set null');
            $table->string('developer')->nullable();
            $table->bigInteger('size')->nullable();
            $table->text('mod_info')->nullable();
            $table->json('screenshots')->nullable();
            $table->string('download_url')->nullable();
            $table->integer('version_code')->nullable();
            $table->enum('status', ['active', 'inactive', 'pending'])->default('active');
            $table->boolean('featured')->default(false);
            $table->timestamps();

            // Indexes
            $table->index('package_name');
            $table->index('slug');
            $table->index('category_id');
            $table->index('status');
            $table->index('featured');
            $table->index('downloads_count');
            $table->index('rating');
            $table->index('updated_at');
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('apps');
    }
};