<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration {
    public function up(): void
    {
        Schema::create('versions', function (Blueprint $table) {
            $table->id();
            $table->foreignId('app_id')->constrained('apps')->cascadeOnDelete();
            $table->string('version_name');
            $table->integer('version_code');
            $table->date('release_date')->nullable();
            $table->text('changelog')->nullable();
            $table->string('download_url')->nullable();
            $table->unsignedBigInteger('size')->nullable();
            $table->string('min_os_version')->nullable();
            $table->string('max_os_version')->nullable();
            $table->boolean('is_beta')->default(false);
            $table->string('status')->default('active');
            $table->timestamps();
        });
    }

    public function down(): void
    {
        Schema::dropIfExists('versions');
    }
};
