<?php

namespace Database\Factories;

use App\Models\App;
use App\Models\Version;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<Version>
 */
class VersionFactory extends Factory
{
    protected $model = Version::class;

    public function definition(): array
    {
        return [
            'app_id' => App::factory(),
            'version_name' => $this->faker->semver(),
            'version_code' => $this->faker->numberBetween(1, 1000),
            'release_date' => $this->faker->date(),
            'changelog' => $this->faker->paragraph(),
            'download_url' => 'https://example.com/download.apk',
            'size' => $this->faker->numberBetween(10_000_000, 150_000_000),
            'min_os_version' => '5.0',
            'max_os_version' => null,
            'is_beta' => false,
            'status' => 'active',
        ];
    }
}