<?php

namespace Database\Factories;

use App\Models\App;
use Illuminate\Database\Eloquent\Factories\Factory;

/**
 * @extends Factory<App>
 */
class AppFactory extends Factory
{
    protected $model = App::class;

    public function definition(): array
    {
        return [
            'package_name' => $this->faker->unique()->slug(),
            'slug' => $this->faker->unique()->slug(),
            'name' => $this->faker->words(3, true),
            'description' => $this->faker->sentence(),
            'icon_url' => null,
            'latest_version' => '1.0.0',
            'rating' => 0,
            'downloads_count' => 0,
            'views_count' => 0,
            'os_requirement' => null,
            'category_id' => null,
            'developer' => $this->faker->company(),
            'size' => null,
            'mod_info' => null,
            'screenshots' => [],
            'download_url' => 'https://example.com/download.apk',
            'version_code' => 1,
            'status' => 'active',
            'featured' => false,
            'updated_at' => now(),
        ];
    }
}