<?php

use App\Imports\Scrapers\JsonFeedScraper;

return [
    /*
    |--------------------------------------------------------------------------
    | Remote Import Sources
    |--------------------------------------------------------------------------
    |
    | Define external providers that can feed APK Center with new applications.
    | Each entry declares its parser, visual meta, and connectivity options.
    |
    */
    'sources' => [
        'community' => [
            'name' => 'Community Feed',
            'description' => 'Lightweight JSON feed for manual curation or partner submissions.',
            'type' => 'JSON Feed',
            'parser' => JsonFeedScraper::class,
            'feed_url' => base_path('resources/sample-feeds/community.json'),
            'brand_color' => '#14b8a6',
            'default_category' => 'community',
        ],
    ],
];
