<?php

namespace App\Providers;

use App\Models\Category;
use Illuminate\Support\ServiceProvider;
use Illuminate\Support\Facades\Schema;
use Illuminate\Support\Facades\URL;
use Illuminate\Support\Facades\Session;
use Illuminate\Support\Facades\App as AppFacade;
use Illuminate\Support\Facades\Cookie;
use Illuminate\Support\Facades\View;
use Illuminate\Support\Facades\Request;
use Illuminate\Support\ViewErrorBag;

class AppServiceProvider extends ServiceProvider
{
    /**
     * Register any application services.
     */
    public function register(): void
    {
        $this->app->singleton('category', fn () => new Category());
    }

    /**
     * Bootstrap any application services.
     */
    public function boot(): void
    {
        // تحديد طول النصوص الافتراضي
        Schema::defaultStringLength(191);

        // إجبار استخدام HTTPS في بيئة الإنتاج
        if (!app()->runningInConsole()) {
            $isSecure = request()->isSecure();
            if (config('app.env') === 'production' || $isSecure) {
                URL::forceScheme('https');
            }

            // تحديد اللغة من Session أو Cookie
            $locale = Session::get('locale') ?? Cookie::get('locale', config('app.locale'));
            $supported = config('app.supported_locales', [config('app.locale')]);
            
            if (!in_array($locale, $supported, true)) {
                $locale = config('app.locale');
            }
            
            AppFacade::setLocale($locale);
        }

        // مشاركة متغير errors مع جميع الـ views (حل مشكلة Orchid)
        View::share('errors', session('errors', new ViewErrorBag()));

        // مشاركة اللغات المدعومة
        View::share('supportedLocales', config('app.supported_locales', [config('app.locale')]));

        // مشاركة المتغيرات العامة مع جميع الـ views
        View::composer('*', function ($view) {
            $locale = app()->getLocale();
            $isRtl = in_array($locale, ['ar', 'he', 'fa']);
            $isDarkMode = Session::get('dark_mode', false);
            $appName = config('app.name', 'APK Center');
            
            $navLinks = [
                [
                    'label' => __('Home'),
                    'route' => route('home'),
                    'active' => Request::routeIs('home')
                ],
                [
                    'label' => __('Latest'),
                    'route' => route('apps.latest'),
                    'active' => Request::routeIs('apps.latest')
                ],
                [
                    'label' => __('Trending'),
                    'route' => route('apps.popular'),
                    'active' => Request::routeIs('apps.popular')
                ],
                [
                    'label' => __('Games'),
                    'route' => route('apps.games'),
                    'active' => Request::routeIs('apps.games')
                ],
                [
                    'label' => __('Categories'),
                    'route' => route('apps.categories'),
                    'active' => Request::routeIs('apps.categories')
                ],
            ];

            $view->with(compact('locale', 'isRtl', 'isDarkMode', 'appName', 'navLinks'));
        });
    }
}