<?php

namespace App\Orchid\Screens;

use Orchid\Screen\Screen;
use Orchid\Support\Facades\Layout;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Fields\TextArea;
use Orchid\Screen\Fields\Switcher;
use Orchid\Screen\Fields\Select;
use Orchid\Screen\Actions\Button;
use Orchid\Support\Facades\Toast;

class SettingsScreen extends Screen
{
    public $name = 'Settings';
    public $description = 'Manage your application settings';

    public function query(): iterable
    {
        return [
            'settings' => [
                'site_name' => config('app.name'),
                'site_url' => config('app.url'),
                'timezone' => config('app.timezone'),
            ],
        ];
    }

    public function commandBar(): iterable
    {
        return [
            Button::make('Save Settings')
                ->icon('bs.check')
                ->method('save'),
        ];
    }

    public function layout(): iterable
    {
        return [
            Layout::rows([
                Input::make('settings.site_name')
                    ->title('Site Name')
                    ->placeholder('Enter site name'),
                Input::make('settings.site_url')
                    ->title('Site URL')
                    ->placeholder('https://example.com'),
                Select::make('settings.timezone')
                    ->title('Timezone')
                    ->options([
                        'UTC' => 'UTC',
                        'Asia/Dubai' => 'Asia/Dubai',
                        'Asia/Riyadh' => 'Asia/Riyadh',
                    ]),
                Switcher::make('settings.maintenance')
                    ->title('Maintenance Mode')
                    ->sendTrueOrFalse(),
            ]),
        ];
    }

    public function save()
    {
        Toast::info('Settings saved successfully!');
    }
}
