<?php

namespace App\Orchid\Screens;

use Orchid\Screen\Screen;
use Orchid\Support\Facades\Layout;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\Link;
use App\Models\User;

class ReportsScreen extends Screen
{
    public $name = 'Reports & Analytics';
    public $description = 'View your application statistics and reports';

    public function query(): iterable
    {
        return [
            'charts' => [
                [
                    'name' => 'Users',
                    'values' => [25, 40, 30, 35, 50, 45, 60],
                    'labels' => ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun'],
                ],
            ],
            'metrics' => [
                'total_users' => User::count(),
                'new_today' => User::whereDate('created_at', today())->count(),
                'new_week' => User::where('created_at', '>=', now()->subWeek())->count(),
                'new_month' => User::where('created_at', '>=', now()->subMonth())->count(),
            ],
        ];
    }

    public function commandBar(): iterable
    {
        return [
            Button::make('Export PDF')
                ->icon('bs.file-pdf')
                ->method('exportPdf'),
            Button::make('Export Excel')
                ->icon('bs.file-excel')
                ->method('exportExcel'),
        ];
    }

    public function layout(): iterable
    {
        return [
            Layout::metrics([
                'Total Users' => 'metrics.total_users',
                'New Today' => 'metrics.new_today',
                'New This Week' => 'metrics.new_week',
                'New This Month' => 'metrics.new_month',
            ]),
        ];
    }

    public function exportPdf()
    {
        \Orchid\Support\Facades\Toast::info('PDF export started!');
    }

    public function exportExcel()
    {
        \Orchid\Support\Facades\Toast::info('Excel export started!');
    }
}
