<?php

namespace App\Orchid\Screens;

use Orchid\Screen\Screen;
use Orchid\Support\Facades\Layout;
use Orchid\Screen\Sight;
use Orchid\Screen\TD;
use Orchid\Screen\Fields\Input;
use Orchid\Screen\Actions\Button;
use Orchid\Screen\Actions\Link;
use App\Models\User;

class DashboardScreen extends Screen
{
    public $name = 'Dashboard';
    public $description = 'Welcome to your Orchid Admin Panel';

    public function query(): iterable
    {
        return [
            'metrics' => [
                'users' => User::count(),
                'active' => User::where('created_at', '>=', now()->subDays(30))->count(),
            ],
        ];
    }

    public function commandBar(): iterable
    {
        return [
            Link::make('Website')
                ->href('https://apks.center')
                ->icon('bs.globe'),
            Button::make('Refresh')
                ->icon('bs.arrow-clockwise')
                ->method('refresh'),
        ];
    }

    public function layout(): iterable
    {
        return [
            Layout::metrics([
                'Total Users' => 'metrics.users',
                'New Users (30 days)' => 'metrics.active',
            ]),
        ];
    }

    public function refresh()
    {
        return redirect()->route('platform.dashboard');
    }
}
