<?php

declare(strict_types=1);

namespace App\Orchid;

use Orchid\Platform\Dashboard;
use Orchid\Platform\ItemPermission;
use Orchid\Platform\OrchidServiceProvider;
use Orchid\Screen\Actions\Menu;
use Orchid\Support\Color;

class PlatformProvider extends OrchidServiceProvider
{
    public function boot(Dashboard $dashboard): void
    {
        parent::boot($dashboard);
    }

    public function menu(): array
    {
        return [
            Menu::make('Dashboard')
                ->icon('bs.house')
                ->route('platform.dashboard')
                ->title('Navigation'),

            Menu::make('Import APKs')
                ->icon('bs.cloud-download')
                ->route('platform.apk-import')
                ->title('Content Management'),

            Menu::make('Export as ZIP')
                ->icon('bs.file-earmark-zip')
                ->route('platform.export-zip'),

            Menu::make('Reports & Analytics')
                ->icon('bs.bar-chart')
                ->route('platform.reports'),

            Menu::make('Settings')
                ->icon('bs.gear')
                ->route('platform.settings'),

            Menu::make('Users')
                ->icon('bs.people')
                ->route('platform.systems.users')
                ->title('Access Controls'),

            Menu::make('Roles')
                ->icon('bs.shield')
                ->route('platform.systems.roles'),

            Menu::make(__('Documentation'))
                ->title('Resources')
                ->icon('bs.book')
                ->url('https://orchid.software/en/docs'),

            Menu::make('GitHub')
                ->icon('bs.github')
                ->url('https://github.com/orchidsoftware/platform'),
        ];
    }

    public function permissions(): array
    {
        return [
            ItemPermission::group(__('System'))
                ->addPermission('platform.systems.roles', __('Roles'))
                ->addPermission('platform.systems.users', __('Users')),

            ItemPermission::group(__('Content'))
                ->addPermission('platform.apk-import', __('Import APKs'))
                ->addPermission('platform.export-zip', __('Export ZIP')),
        ];
    }
}
